/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import lombok.Generated;

public final class CatalogSwitchableDataSource
implements DataSource,
AutoCloseable {
    private final DataSource dataSource;
    private final String catalog;
    private final String url;

    @Override
    public Connection getConnection() throws SQLException {
        Connection result = this.dataSource.getConnection();
        if (null != this.catalog && !this.catalog.equals(result.getCatalog())) {
            result.setCatalog(this.catalog);
        }
        return result;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void close() throws Exception {
        if (this.dataSource instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.dataSource)).close();
        }
    }

    @Generated
    public CatalogSwitchableDataSource(DataSource dataSource, String catalog, String url) {
        this.dataSource = dataSource;
        this.catalog = catalog;
        this.url = url;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }
}

