/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.rule.tuple;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlGlobalRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleItem;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.config.GlobalRuleNodePath;
import org.apache.shardingsphere.mode.node.rule.node.DatabaseRuleNode;
import org.apache.shardingsphere.mode.node.rule.node.DatabaseRuleNodeGenerator;
import org.apache.shardingsphere.mode.node.rule.tuple.RuleNodeTuple;
import org.apache.shardingsphere.mode.node.rule.tuple.YamlRuleConfigurationReflectionEngine;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleEntity;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleKeyListNameGenerator;

public final class YamlRuleNodeTupleSwapperEngine {
    public RuleNodeTuple swapToTuple(YamlGlobalRuleConfiguration yamlGlobalRuleConfig) {
        RuleNodeTupleEntity entity = yamlGlobalRuleConfig.getClass().getAnnotation(RuleNodeTupleEntity.class);
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkArgument((boolean)entity.leaf());
        return new RuleNodeTuple(new GlobalRuleNodePath(entity.value()), YamlEngine.marshal((Object)yamlGlobalRuleConfig));
    }

    public Collection<RuleNodeTuple> swapToTuples(String databaseName, YamlRuleConfiguration yamlRuleConfig) {
        RuleNodeTupleEntity entity = yamlRuleConfig.getClass().getAnnotation(RuleNodeTupleEntity.class);
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkArgument((!entity.leaf() ? 1 : 0) != 0);
        String ruleType = entity.value();
        LinkedList<RuleNodeTuple> result = new LinkedList<RuleNodeTuple>();
        for (Field each : YamlRuleConfigurationReflectionEngine.getFields(yamlRuleConfig.getClass())) {
            boolean isAccessible = each.isAccessible();
            each.setAccessible(true);
            result.addAll(this.swapToTuples(databaseName, ruleType, yamlRuleConfig, each));
            each.setAccessible(isAccessible);
        }
        return result;
    }

    private Collection<RuleNodeTuple> swapToTuples(String databaseName, String ruleType, YamlRuleConfiguration yamlRuleConfig, Field field) {
        Object fieldValue = field.get(yamlRuleConfig);
        if (null == fieldValue) {
            return Collections.emptyList();
        }
        String ruleItemName = YamlRuleConfigurationReflectionEngine.getRuleNodeItemName(field);
        return this.isNamedItem(field) ? this.swapToNamedTuples(databaseName, ruleType, ruleItemName, field, fieldValue) : (Collection)this.swapToUniqueTuple(databaseName, ruleType, ruleItemName, fieldValue).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private Collection<RuleNodeTuple> swapToNamedTuples(String databaseName, String ruleType, String ruleItemType, Field field, Object fieldValue) {
        LinkedList<RuleNodeTuple> result = new LinkedList<RuleNodeTuple>();
        if (fieldValue instanceof Map) {
            for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                String ruleItemName = entry.getKey().toString();
                result.add(new RuleNodeTuple(new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(ruleItemType, ruleItemName)), YamlEngine.marshal(entry.getValue())));
            }
        } else {
            for (Object each : (Collection)fieldValue) {
                String ruleItemName = field.getAnnotation(RuleNodeTupleKeyListNameGenerator.class).value().getConstructor(new Class[0]).newInstance(new Object[0]).generate(each);
                result.add(new RuleNodeTuple(new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(ruleItemType, ruleItemName)), each.toString()));
            }
        }
        return result;
    }

    private Optional<RuleNodeTuple> swapToUniqueTuple(String databaseName, String ruleType, String ruleItemType, Object fieldValue) {
        DatabaseRuleNodePath databaseRuleNodePath = new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(ruleItemType));
        if (fieldValue instanceof Collection) {
            return ((Collection)fieldValue).isEmpty() ? Optional.empty() : Optional.of(new RuleNodeTuple(databaseRuleNodePath, YamlEngine.marshal((Object)fieldValue)));
        }
        if (fieldValue instanceof String) {
            return ((String)fieldValue).isEmpty() ? Optional.empty() : Optional.of(new RuleNodeTuple(databaseRuleNodePath, fieldValue.toString()));
        }
        if (fieldValue instanceof Boolean || fieldValue instanceof Integer || fieldValue instanceof Long) {
            return Optional.of(new RuleNodeTuple(databaseRuleNodePath, fieldValue.toString()));
        }
        if (fieldValue instanceof Enum) {
            return Optional.of(new RuleNodeTuple(databaseRuleNodePath, ((Enum)fieldValue).name()));
        }
        return Optional.of(new RuleNodeTuple(databaseRuleNodePath, YamlEngine.marshal((Object)fieldValue)));
    }

    public YamlRuleConfiguration swapToYamlGlobalRuleConfiguration(String ruleType, String ruleContent) {
        return (YamlRuleConfiguration)YamlEngine.unmarshal((String)ruleContent, YamlRuleConfigurationReflectionEngine.findClass(ruleType));
    }

    public YamlRuleConfiguration swapToYamlDatabaseRuleConfiguration(String databaseName, String ruleType, Collection<RuleNodeTuple> tuples) {
        Class<? extends YamlRuleConfiguration> yamlRuleConfigClass = YamlRuleConfigurationReflectionEngine.findClass(ruleType);
        Collection<Field> fields = YamlRuleConfigurationReflectionEngine.getFields(yamlRuleConfigClass);
        YamlRuleConfiguration result = yamlRuleConfigClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        DatabaseRuleNode databaseRuleNode = DatabaseRuleNodeGenerator.generate(yamlRuleConfigClass);
        for (RuleNodeTuple each : tuples) {
            if (Strings.isNullOrEmpty((String)each.getContent())) continue;
            this.setFieldValue(databaseName, result, fields, databaseRuleNode.getRuleType(), each);
        }
        return result;
    }

    private void setFieldValue(String databaseName, YamlRuleConfiguration yamlRuleConfig, Collection<Field> fields, String ruleType, RuleNodeTuple tuple) {
        for (Field each : fields) {
            boolean isAccessible = each.isAccessible();
            each.setAccessible(true);
            this.setFieldValue(databaseName, yamlRuleConfig, each, ruleType, tuple);
            each.setAccessible(isAccessible);
        }
    }

    private void setFieldValue(String databaseName, YamlRuleConfiguration yamlRuleConfig, Field field, String ruleType, RuleNodeTuple tuple) {
        String itemType = YamlRuleConfigurationReflectionEngine.getRuleNodeItemName(field);
        if (this.isNamedItem(field)) {
            this.setNamedItemFieldValue(databaseName, yamlRuleConfig, ruleType, tuple, itemType, field);
        } else {
            this.setUniqueItemFieldValue(databaseName, yamlRuleConfig, ruleType, tuple, itemType, field);
        }
    }

    private boolean isNamedItem(Field field) {
        return field.getType().equals(Map.class) || null != field.getAnnotation(RuleNodeTupleKeyListNameGenerator.class) && field.getType().equals(Collection.class);
    }

    private void setNamedItemFieldValue(String databaseName, YamlRuleConfiguration yamlRuleConfig, String ruleType, RuleNodeTuple tuple, String itemType, Field field) {
        DatabaseRuleNodePath databaseRuleNodePath = new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(itemType, "([\\w-]+(?:[:.][\\w-]+)*)"));
        Optional<String> itemValue = NodePathSearcher.find(tuple.getPath(), new NodePathSearchCriteria(databaseRuleNodePath, true, 1));
        if (!itemValue.isPresent()) {
            return;
        }
        Object fieldValue = field.get(yamlRuleConfig);
        if (field.getType().equals(Map.class)) {
            if (null == fieldValue) {
                field.set(yamlRuleConfig, new HashMap());
            }
            fieldValue = field.get(yamlRuleConfig);
            Class valueClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
            ((Map)fieldValue).put(itemValue.get(), YamlEngine.unmarshal((String)tuple.getContent(), (Class)valueClass));
        } else {
            if (null == fieldValue) {
                field.set(yamlRuleConfig, new LinkedList());
            }
            fieldValue = field.get(yamlRuleConfig);
            ((Collection)fieldValue).add(tuple.getContent());
        }
    }

    private void setUniqueItemFieldValue(String databaseName, YamlRuleConfiguration yamlRuleConfig, String ruleType, RuleNodeTuple tuple, String itemType, Field field) {
        DatabaseRuleNodePath databaseRuleNodePath = new DatabaseRuleNodePath(databaseName, ruleType, new DatabaseRuleItem(itemType));
        if (!NodePathSearcher.isMatchedPath(tuple.getPath(), new NodePathSearchCriteria(databaseRuleNodePath, true, 1))) {
            return;
        }
        if (field.getType().equals(Collection.class)) {
            field.set(yamlRuleConfig, YamlEngine.unmarshal((String)tuple.getContent(), List.class));
        } else if (field.getType().equals(String.class)) {
            field.set(yamlRuleConfig, tuple.getContent());
        } else if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
            field.set(yamlRuleConfig, Boolean.parseBoolean(tuple.getContent()));
        } else if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
            field.set(yamlRuleConfig, Integer.parseInt(tuple.getContent()));
        } else if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
            field.set(yamlRuleConfig, Long.parseLong(tuple.getContent()));
        } else {
            field.set(yamlRuleConfig, YamlEngine.unmarshal((String)tuple.getContent(), field.getType()));
        }
    }
}

