/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.rule.node;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.node.rule.node.DatabaseRuleNode;
import org.apache.shardingsphere.mode.node.rule.tuple.YamlRuleConfigurationReflectionEngine;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleEntity;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleField;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleKeyListNameGenerator;

public final class DatabaseRuleNodeGenerator {
    public static DatabaseRuleNode generate(Class<? extends YamlRuleConfiguration> yamlRuleConfigClass) {
        RuleNodeTupleEntity tupleEntity = yamlRuleConfigClass.getAnnotation(RuleNodeTupleEntity.class);
        Preconditions.checkNotNull((Object)tupleEntity, (String)"Can not find @RuleNodeTupleEntity on class: ", (Object)yamlRuleConfigClass.getName());
        LinkedList<String> namedItems = new LinkedList<String>();
        LinkedList<String> uniqueItems = new LinkedList<String>();
        for (Field each : YamlRuleConfigurationReflectionEngine.getFields(yamlRuleConfigClass)) {
            if (null == each.getAnnotation(RuleNodeTupleField.class)) continue;
            String tupleName = YamlRuleConfigurationReflectionEngine.getRuleNodeItemName(each);
            if (each.getType().equals(Map.class) || each.getType().equals(Collection.class) && null != each.getAnnotation(RuleNodeTupleKeyListNameGenerator.class)) {
                namedItems.add(tupleName);
                continue;
            }
            uniqueItems.add(tupleName);
        }
        return new DatabaseRuleNode(tupleEntity.value(), namedItems, uniqueItems);
    }

    public static DatabaseRuleNode generate(String ruleType) {
        return DatabaseRuleNodeGenerator.findYamlRuleConfigurationClass(ruleType).map(DatabaseRuleNodeGenerator::generate).orElseThrow(() -> new IllegalArgumentException(ruleType));
    }

    private static Optional<Class<? extends YamlRuleConfiguration>> findYamlRuleConfigurationClass(String ruleType) {
        for (YamlRuleConfigurationSwapper each : ShardingSphereServiceLoader.getServiceInstances(YamlRuleConfigurationSwapper.class)) {
            RuleNodeTupleEntity entity;
            Optional<Class<? extends YamlRuleConfiguration>> yamlRuleConfigClass = DatabaseRuleNodeGenerator.findYamlRuleConfigurationClass(each.getClass());
            if (!yamlRuleConfigClass.isPresent() || null == (entity = yamlRuleConfigClass.get().getAnnotation(RuleNodeTupleEntity.class)) || !entity.value().equals(ruleType)) continue;
            return yamlRuleConfigClass;
        }
        return Optional.empty();
    }

    private static Optional<Class<? extends YamlRuleConfiguration>> findYamlRuleConfigurationClass(Class<? extends YamlRuleConfigurationSwapper> swapperClass) {
        for (Type each : swapperClass.getGenericInterfaces()) {
            if (!(each instanceof ParameterizedType)) continue;
            return Optional.of((Class)((ParameterizedType)each).getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }

    @Generated
    private DatabaseRuleNodeGenerator() {
    }
}

