/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.version;

import java.util.regex.Pattern;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;

public final class VersionNodePath {
    private static final String ACTIVE_VERSION = "active_version";
    private static final String VERSIONS = "versions";
    private final String path;

    public VersionNodePath(NodePath nodePath) {
        this.path = NodePathGenerator.toPath(nodePath);
    }

    public String getActiveVersionPath() {
        return String.join((CharSequence)"/", this.path, ACTIVE_VERSION);
    }

    public String getVersionsPath() {
        return String.join((CharSequence)"/", this.path, VERSIONS);
    }

    public String getVersionPath(int version) {
        return String.join((CharSequence)"/", this.getVersionsPath(), String.valueOf(version));
    }

    public boolean isActiveVersionPath(String path) {
        return this.createActiveVersionPathPattern().matcher(path).find();
    }

    private Pattern createActiveVersionPathPattern() {
        return Pattern.compile(this.getActiveVersionPath() + "$", 2);
    }

    public boolean isVersionsPath(String path) {
        return this.createVersionsPathPattern().matcher(path).find();
    }

    private Pattern createVersionsPathPattern() {
        return Pattern.compile(this.getVersionsPath(), 2);
    }
}

