/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.type;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.DorisStatementParser;
import org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.DorisStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.PartitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.job.JobNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.property.PropertiesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.property.PropertySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnMappingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.IndexHintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.CallStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DoStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.doris.dml.DorisAlterRoutineLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dml.DorisCreateRoutineLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dml.DorisPauseRoutineLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dml.DorisResumeRoutineLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dml.DorisStopRoutineLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLHandlerStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLImportStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLLoadDataStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLLoadXMLStatement;

public final class DorisDMLStatementVisitor
extends DorisStatementVisitor
implements DMLStatementVisitor {
    public DorisDMLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCall(DorisStatementParser.CallContext ctx) {
        String procedureName = null == ctx.owner() ? ctx.identifier().getText() : ctx.owner().getText() + "." + ctx.identifier().getText();
        List params = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        return new CallStatement(this.getDatabaseType(), procedureName, params);
    }

    @Override
    public ASTNode visitDoStatement(DorisStatementParser.DoStatementContext ctx) {
        return new DoStatement(this.getDatabaseType(), ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitHandlerStatement(DorisStatementParser.HandlerStatementContext ctx) {
        return new MySQLHandlerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitImportStatement(DorisStatementParser.ImportStatementContext ctx) {
        return new MySQLImportStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitLoadStatement(DorisStatementParser.LoadStatementContext ctx) {
        return null == ctx.loadDataStatement() ? (ASTNode)this.visit((ParseTree)ctx.loadXmlStatement()) : (ASTNode)this.visit((ParseTree)ctx.loadDataStatement());
    }

    @Override
    public ASTNode visitLoadDataStatement(DorisStatementParser.LoadDataStatementContext ctx) {
        return new MySQLLoadDataStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitLoadXmlStatement(DorisStatementParser.LoadXmlStatementContext ctx) {
        return new MySQLLoadXMLStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitCreateRoutineLoad(DorisStatementParser.CreateRoutineLoadContext ctx) {
        PropertySegment propertySegment;
        String value;
        String key;
        ParserRuleContext propertyCtx;
        PropertiesSegment propertiesSegment;
        DorisCreateRoutineLoadStatement result = new DorisCreateRoutineLoadStatement(this.getDatabaseType());
        if (null != ctx.jobName()) {
            JobNameSegment jobName = new JobNameSegment(ctx.jobName().start.getStartIndex(), ctx.jobName().stop.getStopIndex(), new IdentifierValue(ctx.jobName().getText()));
            if (null != ctx.owner()) {
                OwnerSegment owner = (OwnerSegment)this.visit((ParseTree)ctx.owner());
                jobName.setOwner(owner);
                result.setDatabase(new DatabaseSegment(ctx.owner().start.getStartIndex(), ctx.owner().stop.getStopIndex(), new IdentifierValue(ctx.owner().getText())));
            }
            result.setJobName(jobName);
        }
        if (null != ctx.tableName()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        }
        if (null != ctx.mergeType()) {
            result.setMergeType(ctx.mergeType().getText());
        }
        if (null != ctx.loadProperty()) {
            for (int i = 0; i < ctx.loadProperty().size(); ++i) {
                DorisStatementParser.LoadPropertyContext loadPropCtx = ctx.loadProperty(i);
                if (null != loadPropCtx.columnSeparatorClause()) {
                    result.setColumnSeparator(SQLUtils.getExactlyValue((String)loadPropCtx.columnSeparatorClause().string_().getText()));
                }
                if (null != loadPropCtx.columnsClause()) {
                    this.processColumnMappings(loadPropCtx.columnsClause(), result);
                }
                if (null != loadPropCtx.precedingFilterClause()) {
                    result.setPrecedingFilter((ExpressionSegment)this.visit((ParseTree)loadPropCtx.precedingFilterClause().expr()));
                }
                if (null != loadPropCtx.whereClause()) {
                    result.setWhere((WhereSegment)this.visit((ParseTree)loadPropCtx.whereClause()));
                }
                if (null != loadPropCtx.partitionNames()) {
                    for (DorisStatementParser.IdentifierContext each : loadPropCtx.partitionNames().identifier()) {
                        PartitionSegment partitionSegment = new PartitionSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)each));
                        result.getPartitions().add(partitionSegment);
                    }
                }
                if (null != loadPropCtx.deleteOnClause()) {
                    result.setDeleteOn((ExpressionSegment)this.visit((ParseTree)loadPropCtx.deleteOnClause().expr()));
                }
                if (null == loadPropCtx.orderByClause()) continue;
                result.setOrderBy((OrderBySegment)this.visit((ParseTree)loadPropCtx.orderByClause()));
            }
        }
        if (null != ctx.jobProperties()) {
            propertiesSegment = new PropertiesSegment(ctx.jobProperties().start.getStartIndex(), ctx.jobProperties().stop.getStopIndex());
            for (int i = 0; i < ctx.jobProperties().jobProperty().size(); ++i) {
                propertyCtx = ctx.jobProperties().jobProperty(i);
                key = this.getPropertyKey(propertyCtx.identifier(), propertyCtx.SINGLE_QUOTED_TEXT(), propertyCtx.DOUBLE_QUOTED_TEXT());
                value = SQLUtils.getExactlyValue((String)propertyCtx.literals().getText());
                propertySegment = new PropertySegment(propertyCtx.start.getStartIndex(), propertyCtx.stop.getStopIndex(), key, value);
                propertiesSegment.getProperties().add(propertySegment);
            }
            result.setJobProperties(propertiesSegment);
        }
        if (null != ctx.dataSource()) {
            result.setDataSource(ctx.dataSource().getText());
        }
        if (null != ctx.dataSourceProperties() && null != ctx.dataSourceProperties().dataSourceProperty()) {
            propertiesSegment = new PropertiesSegment(ctx.dataSourceProperties().start.getStartIndex(), ctx.dataSourceProperties().stop.getStopIndex());
            for (int i = 0; i < ctx.dataSourceProperties().dataSourceProperty().size(); ++i) {
                propertyCtx = ctx.dataSourceProperties().dataSourceProperty(i);
                key = this.getPropertyKey(propertyCtx.identifier(), propertyCtx.SINGLE_QUOTED_TEXT(), propertyCtx.DOUBLE_QUOTED_TEXT());
                value = SQLUtils.getExactlyValue((String)propertyCtx.literals().getText());
                propertySegment = new PropertySegment(propertyCtx.start.getStartIndex(), propertyCtx.stop.getStopIndex(), key, value);
                propertiesSegment.getProperties().add(propertySegment);
            }
            result.setDataSourceProperties(propertiesSegment);
        }
        if (null != ctx.string_()) {
            result.setComment(SQLUtils.getExactlyValue((String)ctx.string_().getText()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitAlterRoutineLoad(DorisStatementParser.AlterRoutineLoadContext ctx) {
        PropertySegment propertySegment;
        String value;
        String key;
        ParserRuleContext propertyCtx;
        PropertiesSegment propertiesSegment;
        DorisAlterRoutineLoadStatement result = new DorisAlterRoutineLoadStatement(this.getDatabaseType());
        if (null != ctx.jobName()) {
            JobNameSegment jobName = new JobNameSegment(ctx.jobName().start.getStartIndex(), ctx.jobName().stop.getStopIndex(), new IdentifierValue(ctx.jobName().getText()));
            if (null != ctx.owner()) {
                OwnerSegment owner = (OwnerSegment)this.visit((ParseTree)ctx.owner());
                jobName.setOwner(owner);
            }
            result.setJobName(jobName);
        }
        if (null != ctx.jobProperties()) {
            propertiesSegment = new PropertiesSegment(ctx.jobProperties().start.getStartIndex(), ctx.jobProperties().stop.getStopIndex());
            for (int i = 0; i < ctx.jobProperties().jobProperty().size(); ++i) {
                propertyCtx = ctx.jobProperties().jobProperty(i);
                key = this.getPropertyKey(propertyCtx.identifier(), propertyCtx.SINGLE_QUOTED_TEXT(), propertyCtx.DOUBLE_QUOTED_TEXT());
                value = SQLUtils.getExactlyValue((String)propertyCtx.literals().getText());
                propertySegment = new PropertySegment(propertyCtx.start.getStartIndex(), propertyCtx.stop.getStopIndex(), key, value);
                propertiesSegment.getProperties().add(propertySegment);
            }
            result.setJobProperties(propertiesSegment);
        }
        if (null != ctx.dataSource()) {
            result.setDataSource(ctx.dataSource().getText());
        }
        if (null != ctx.dataSourceProperties() && null != ctx.dataSourceProperties().dataSourceProperty()) {
            propertiesSegment = new PropertiesSegment(ctx.dataSourceProperties().start.getStartIndex(), ctx.dataSourceProperties().stop.getStopIndex());
            for (int i = 0; i < ctx.dataSourceProperties().dataSourceProperty().size(); ++i) {
                propertyCtx = ctx.dataSourceProperties().dataSourceProperty(i);
                key = this.getPropertyKey(propertyCtx.identifier(), propertyCtx.SINGLE_QUOTED_TEXT(), propertyCtx.DOUBLE_QUOTED_TEXT());
                value = SQLUtils.getExactlyValue((String)propertyCtx.literals().getText());
                propertySegment = new PropertySegment(propertyCtx.start.getStartIndex(), propertyCtx.stop.getStopIndex(), key, value);
                propertiesSegment.getProperties().add(propertySegment);
            }
            result.setDataSourceProperties(propertiesSegment);
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitPauseRoutineLoad(DorisStatementParser.PauseRoutineLoadContext ctx) {
        DorisPauseRoutineLoadStatement result = new DorisPauseRoutineLoadStatement(this.getDatabaseType());
        result.setAll(null != ctx.ALL());
        if (null != ctx.jobName()) {
            JobNameSegment jobName = new JobNameSegment(ctx.jobName().start.getStartIndex(), ctx.jobName().stop.getStopIndex(), new IdentifierValue(ctx.jobName().getText()));
            if (null != ctx.owner()) {
                OwnerSegment owner = (OwnerSegment)this.visit((ParseTree)ctx.owner());
                jobName.setOwner(owner);
            }
            result.setJobName(jobName);
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitResumeRoutineLoad(DorisStatementParser.ResumeRoutineLoadContext ctx) {
        DorisResumeRoutineLoadStatement result = new DorisResumeRoutineLoadStatement(this.getDatabaseType());
        result.setAll(null != ctx.ALL());
        if (null != ctx.jobName()) {
            JobNameSegment jobName = new JobNameSegment(ctx.jobName().start.getStartIndex(), ctx.jobName().stop.getStopIndex(), new IdentifierValue(ctx.jobName().getText()));
            if (null != ctx.owner()) {
                OwnerSegment owner = (OwnerSegment)this.visit((ParseTree)ctx.owner());
                jobName.setOwner(owner);
            }
            result.setJobName(jobName);
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitStopRoutineLoad(DorisStatementParser.StopRoutineLoadContext ctx) {
        DorisStopRoutineLoadStatement result = new DorisStopRoutineLoadStatement(this.getDatabaseType());
        if (null != ctx.jobName()) {
            JobNameSegment jobName = new JobNameSegment(ctx.jobName().start.getStartIndex(), ctx.jobName().stop.getStopIndex(), new IdentifierValue(ctx.jobName().getText()));
            if (null != ctx.owner()) {
                OwnerSegment owner = (OwnerSegment)this.visit((ParseTree)ctx.owner());
                jobName.setOwner(owner);
            }
            result.setJobName(jobName);
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    private void processColumnMappings(DorisStatementParser.ColumnsClauseContext columnsClauseCtx, DorisCreateRoutineLoadStatement statement) {
        for (int i = 0; i < columnsClauseCtx.columnMapping().size(); ++i) {
            DorisStatementParser.ColumnMappingContext mappingCtx = columnsClauseCtx.columnMapping(i);
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)mappingCtx.columnName());
            ColumnMappingSegment columnMapping = new ColumnMappingSegment(mappingCtx.start.getStartIndex(), mappingCtx.stop.getStopIndex(), column);
            if (null != mappingCtx.expr()) {
                columnMapping.setMappingExpression((ExpressionSegment)this.visit((ParseTree)mappingCtx.expr()));
            }
            statement.getColumnMappings().add(columnMapping);
        }
    }

    private String getPropertyKey(DorisStatementParser.IdentifierContext identifier, TerminalNode singleQuotedText, TerminalNode doubleQuotedText) {
        if (null != singleQuotedText) {
            return SQLUtils.getExactlyValue((String)singleQuotedText.getText());
        }
        if (null != doubleQuotedText) {
            return SQLUtils.getExactlyValue((String)doubleQuotedText.getText());
        }
        return SQLUtils.getExactlyValue((String)identifier.getText());
    }

    @Override
    public ASTNode visitIndexHint(DorisStatementParser.IndexHintContext ctx) {
        LinkedList indexNames = new LinkedList();
        if (null != ctx.indexNameList()) {
            ctx.indexNameList().indexName().forEach(each -> indexNames.add(each.getText()));
        }
        String useType = null != ctx.USE() ? ctx.USE().getText() : (null != ctx.IGNORE() ? ctx.IGNORE().getText() : ctx.FORCE().getText());
        IndexHintSegment result = new IndexHintSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), indexNames, useType, null == ctx.INDEX() ? ctx.KEY().getText() : ctx.INDEX().getText(), this.getOriginalText(ctx));
        if (null != ctx.indexHintClause().FOR()) {
            String hintScope = null != ctx.indexHintClause().JOIN() ? "JOIN" : (null != ctx.indexHintClause().ORDER() ? "ORDER BY" : "GROUP BY");
            result.setHintScope(hintScope);
        }
        return result;
    }

    @Override
    public ASTNode visitWindowClause(DorisStatementParser.WindowClauseContext ctx) {
        WindowSegment result = new WindowSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (DorisStatementParser.WindowItemContext each : ctx.windowItem()) {
            result.getItemSegments().add((WindowItemSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWindowItem(DorisStatementParser.WindowItemContext ctx) {
        WindowItemSegment result = new WindowItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.setWindowName(new IdentifierValue(ctx.identifier().getText()));
        WindowItemSegment windowItemSegment = (WindowItemSegment)this.visit((ParseTree)ctx.windowSpecification());
        result.setPartitionListSegments(windowItemSegment.getPartitionListSegments());
        result.setOrderBySegment(windowItemSegment.getOrderBySegment());
        result.setFrameClause(windowItemSegment.getFrameClause());
        return result;
    }

    @Override
    public ASTNode visitWindowSpecification(DorisStatementParser.WindowSpecificationContext ctx) {
        WindowItemSegment result = new WindowItemSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.PARTITION()) {
            result.setPartitionListSegments(this.getExpressions(ctx.expr()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBySegment((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.frameClause()) {
            result.setFrameClause((ExpressionSegment)new CommonExpressionSegment(ctx.frameClause().start.getStartIndex(), ctx.frameClause().stop.getStopIndex(), ctx.frameClause().getText()));
        }
        if (null != ctx.identifier()) {
            result.setWindowName(new IdentifierValue(ctx.identifier().getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitWindowFunction(DorisStatementParser.WindowFunctionContext ctx) {
        super.visitWindowFunction(ctx);
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcName.getText(), this.getOriginalText(ctx));
        if (null != ctx.NTILE()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr()));
        }
        if (null != ctx.LEAD() || null != ctx.LAG() || null != ctx.FIRST_VALUE() || null != ctx.LAST_VALUE()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        }
        if (null != ctx.NTH_VALUE()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr()));
        }
        result.setWindow((WindowItemSegment)this.visit((ParseTree)ctx.windowingClause()));
        return result;
    }

    @Override
    public ASTNode visitWindowingClause(DorisStatementParser.WindowingClauseContext ctx) {
        WindowItemSegment result = new WindowItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.windowName) {
            result.setWindowName((IdentifierValue)this.visit((ParseTree)ctx.windowName));
        }
        if (null != ctx.windowSpecification()) {
            WindowItemSegment windowItemSegment = (WindowItemSegment)this.visit((ParseTree)ctx.windowSpecification());
            result.setPartitionListSegments(windowItemSegment.getPartitionListSegments());
            result.setOrderBySegment(windowItemSegment.getOrderBySegment());
            result.setFrameClause(windowItemSegment.getFrameClause());
        }
        return result;
    }
}

