/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.type;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.DorisStatementParser;
import org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.DorisStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.CacheTableIndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.CloneActionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.CloneInstanceSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromDatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.JobNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.LoadTableIndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.PartitionDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.PartitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.RepositoryNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ResetMasterOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ResetOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ResetSlaveOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.RuleNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowLikeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.property.PropertiesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.property.PropertySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.FunctionNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.AnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.RefreshStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ShowAlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ShowBuildIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.UnsetVariableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.LiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.DateTimeLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NullLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.TemporalLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisAlterResourceStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisAlterSqlBlockRuleStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisAlterSystemStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisCreateRepositoryStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisCreateSqlBlockRuleStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisDescFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisDropRepositoryStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisDropSqlBlockRuleStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisShowCreateRoutineLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisShowFunctionsStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisShowProcStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisShowRoutineLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisShowRoutineLoadTaskStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisShowSqlBlockRuleStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisSwitchStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.DorisSyncStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.show.DorisShowQueryStatsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLCloneStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLCreateLoadableFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLDelimiterStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLFlushStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLHelpStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLKillStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLResetPersistStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLResetStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLRestartStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShutdownStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLUseStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.component.MySQLInstallComponentStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.component.MySQLUninstallComponentStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.index.MySQLCacheIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.index.MySQLLoadIndexInfoStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.plugin.MySQLInstallPluginStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.plugin.MySQLShowPluginsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.plugin.MySQLUninstallPluginStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.binlog.MySQLBinlogStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.binlog.MySQLShowBinaryLogsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.binlog.MySQLShowBinlogEventsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLChangeMasterStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLChangeReplicationSourceToStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLStartReplicaStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLStartSlaveStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLStopSlaveStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowMasterStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowRelayLogEventsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowReplicaStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowReplicasStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowSlaveHostsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowSlaveStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLAlterResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLCreateResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLDropResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLSetResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.MySQLShowOtherStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.character.MySQLShowCharacterSetStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.character.MySQLShowCollationStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLDescribeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.engine.MySQLShowEngineStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.error.MySQLShowErrorsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.error.MySQLShowWarningsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.event.MySQLShowCreateEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.event.MySQLShowEventsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.function.MySQLShowCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.function.MySQLShowFunctionCodeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.function.MySQLShowFunctionStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.index.MySQLShowIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.privilege.MySQLShowCreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.privilege.MySQLShowGrantsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.privilege.MySQLShowPrivilegesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.procedure.MySQLShowCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.procedure.MySQLShowProcedureCodeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.procedure.MySQLShowProcedureStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.process.MySQLShowProcessListStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.profile.MySQLShowProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.profile.MySQLShowProfilesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowOpenTablesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTablesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.trigger.MySQLShowCreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.trigger.MySQLShowTriggersStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.variable.MySQLShowVariablesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.view.MySQLShowCreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLCheckTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLChecksumTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLOptimizeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLRepairTableStatement;

public final class DorisDALStatementVisitor
extends DorisStatementVisitor
implements DALStatementVisitor {
    public DorisDALStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitUninstallPlugin(DorisStatementParser.UninstallPluginContext ctx) {
        return new MySQLUninstallPluginStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.pluginName())).getValue());
    }

    @Override
    public ASTNode visitShowCreateDatabase(DorisStatementParser.ShowCreateDatabaseContext ctx) {
        return new MySQLShowCreateDatabaseStatement(this.getDatabaseType(), ((DatabaseSegment)this.visit((ParseTree)ctx.databaseName())).getIdentifier().getValue());
    }

    @Override
    public ASTNode visitShowBinaryLogs(DorisStatementParser.ShowBinaryLogsContext ctx) {
        return new MySQLShowBinaryLogsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowStatus(DorisStatementParser.ShowStatusContext ctx) {
        MySQLShowStatusStatement result = new MySQLShowStatusStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCreateView(DorisStatementParser.ShowCreateViewContext ctx) {
        return new MySQLShowCreateViewStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitShowEngines(DorisStatementParser.ShowEnginesContext ctx) {
        return new MySQLShowOtherStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowEngine(DorisStatementParser.ShowEngineContext ctx) {
        return new MySQLShowEngineStatement(this.getDatabaseType(), ctx.engineRef().getText());
    }

    @Override
    public ASTNode visitShowCharset(DorisStatementParser.ShowCharsetContext ctx) {
        return new MySQLShowOtherStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowCreateEvent(DorisStatementParser.ShowCreateEventContext ctx) {
        return new MySQLShowCreateEventStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.eventName())).getValue());
    }

    @Override
    public ASTNode visitShowCreateFunction(DorisStatementParser.ShowCreateFunctionContext ctx) {
        return new MySQLShowCreateFunctionStatement(this.getDatabaseType(), ((FunctionSegment)this.visit((ParseTree)ctx.functionName())).getFunctionName());
    }

    @Override
    public ASTNode visitShowCreateProcedure(DorisStatementParser.ShowCreateProcedureContext ctx) {
        return new MySQLShowCreateProcedureStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.procedureName())).getValue());
    }

    @Override
    public ASTNode visitShowBinlogEvents(DorisStatementParser.ShowBinlogEventsContext ctx) {
        return new MySQLShowBinlogEventsStatement(this.getDatabaseType(), null == ctx.logName() ? null : ctx.logName().getText(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitShowErrors(DorisStatementParser.ShowErrorsContext ctx) {
        return new MySQLShowErrorsStatement(this.getDatabaseType(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitShowWarnings(DorisStatementParser.ShowWarningsContext ctx) {
        return new MySQLShowWarningsStatement(this.getDatabaseType(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitResetStatement(DorisStatementParser.ResetStatementContext ctx) {
        DorisStatementParser.ResetPersistContext persistContext = ctx.resetPersist();
        return null == persistContext ? new MySQLResetStatement(this.getDatabaseType(), ctx.resetOption().stream().filter(each -> null != each.MASTER() || null != each.SLAVE()).map(each -> (ResetOptionSegment)this.visit((ParseTree)each)).collect(Collectors.toList())) : (ASTNode)this.visit((ParseTree)persistContext);
    }

    @Override
    public ASTNode visitResetPersist(DorisStatementParser.ResetPersistContext ctx) {
        return new MySQLResetPersistStatement(this.getDatabaseType(), null != ctx.ifExists(), null == ctx.identifier() ? null : new IdentifierValue(ctx.identifier().getText()));
    }

    @Override
    public ASTNode visitResetOption(DorisStatementParser.ResetOptionContext ctx) {
        if (null != ctx.MASTER()) {
            ResetMasterOptionSegment result = new ResetMasterOptionSegment();
            if (null != ctx.binaryLogFileIndexNumber()) {
                result.setBinaryLogFileIndexNumber(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.binaryLogFileIndexNumber())).getValue().longValue()));
            }
            result.setStartIndex(ctx.start.getStartIndex());
            result.setStopIndex(ctx.stop.getStopIndex());
            return result;
        }
        ResetSlaveOptionSegment result = new ResetSlaveOptionSegment();
        if (null != ctx.ALL()) {
            result.setAll(true);
        }
        if (null != ctx.channelOption()) {
            result.setChannelOption(((StringLiteralValue)this.visit((ParseTree)ctx.channelOption())).getValue());
        }
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        return result;
    }

    @Override
    public ASTNode visitChannelOption(DorisStatementParser.ChannelOptionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.string_());
    }

    @Override
    public ASTNode visitBinaryLogFileIndexNumber(DorisStatementParser.BinaryLogFileIndexNumberContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public ASTNode visitShowReplicas(DorisStatementParser.ShowReplicasContext ctx) {
        return new MySQLShowReplicasStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRepairTable(DorisStatementParser.RepairTableContext ctx) {
        return new MySQLRepairTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitAnalyzeTable(DorisStatementParser.AnalyzeTableContext ctx) {
        return new AnalyzeTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitCacheIndex(DorisStatementParser.CacheIndexContext ctx) {
        IdentifierValue name = null == ctx.DEFAULT() ? (IdentifierValue)this.visit((ParseTree)ctx.identifier()) : new IdentifierValue(ctx.DEFAULT().getText());
        List tableIndexes = null == ctx.cacheTableIndexList() ? Collections.emptyList() : (Collection)ctx.cacheTableIndexList().stream().map(each -> (CacheTableIndexSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        PartitionDefinitionSegment partitionDefinition = null == ctx.partitionList() ? null : new PartitionDefinitionSegment(ctx.tableName().getStart().getStartIndex(), ctx.partitionList().getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), ((CollectionValue)this.visit((ParseTree)ctx.partitionList())).getValue());
        return new MySQLCacheIndexStatement(this.getDatabaseType(), name, tableIndexes, partitionDefinition);
    }

    @Override
    public ASTNode visitCacheTableIndexList(DorisStatementParser.CacheTableIndexListContext ctx) {
        CacheTableIndexSegment result = new CacheTableIndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        for (DorisStatementParser.IndexNameContext each : ctx.indexName()) {
            result.getIndexes().add((IndexSegment)this.visitIndexName(each));
        }
        return result;
    }

    @Override
    public ASTNode visitPartitionList(DorisStatementParser.PartitionListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.PartitionNameContext each : ctx.partitionName()) {
            result.getValue().add((PartitionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitPartitionName(DorisStatementParser.PartitionNameContext ctx) {
        return new PartitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitChecksumTable(DorisStatementParser.ChecksumTableContext ctx) {
        return new MySQLChecksumTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitFlush(DorisStatementParser.FlushContext ctx) {
        return null == ctx.tablesOption() ? new MySQLFlushStatement(this.getDatabaseType(), Collections.emptyList(), false) : (ASTNode)this.visit((ParseTree)ctx.tablesOption());
    }

    @Override
    public ASTNode visitTablesOption(DorisStatementParser.TablesOptionContext ctx) {
        return new MySQLFlushStatement(this.getDatabaseType(), (Collection)ctx.tableName().stream().map(each -> (SimpleTableSegment)this.visit((ParseTree)each)).collect(Collectors.toList()), true);
    }

    @Override
    public ASTNode visitSync(DorisStatementParser.SyncContext ctx) {
        return new DorisSyncStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitKill(DorisStatementParser.KillContext ctx) {
        String processId = null != ctx.NUMBER_() ? ctx.NUMBER_().getText() : (null == ctx.AT_() ? ctx.IDENTIFIER_().getText() : ctx.AT_().getText() + ctx.IDENTIFIER_().getText());
        return new MySQLKillStatement(this.getDatabaseType(), processId, null);
    }

    @Override
    public ASTNode visitLoadIndexInfo(DorisStatementParser.LoadIndexInfoContext ctx) {
        return new MySQLLoadIndexInfoStatement(this.getDatabaseType(), (Collection)ctx.loadTableIndexList().stream().map(each -> (LoadTableIndexSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitLoadTableIndexList(DorisStatementParser.LoadTableIndexListContext ctx) {
        LoadTableIndexSegment result = new LoadTableIndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.indexName()) {
            for (DorisStatementParser.IndexNameContext each : ctx.indexName()) {
                result.getIndexes().add((IndexSegment)this.visitIndexName(each));
            }
        }
        if (null != ctx.partitionList()) {
            result.getPartitions().addAll(((CollectionValue)this.visit((ParseTree)ctx.partitionList())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitInstallPlugin(DorisStatementParser.InstallPluginContext ctx) {
        if (null != ctx.pluginName()) {
            return new MySQLInstallPluginStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.pluginName())).getValue());
        }
        String source = this.getPluginSource(ctx.pluginSource());
        Map<String, String> properties = null == ctx.pluginPropertiesList() ? null : this.extractPluginProperties(ctx.pluginPropertiesList());
        return new MySQLInstallPluginStatement(this.getDatabaseType(), source, properties);
    }

    private String getPluginSource(DorisStatementParser.PluginSourceContext ctx) {
        if (null != ctx.identifier()) {
            return ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        }
        return ((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue();
    }

    private Map<String, String> extractPluginProperties(DorisStatementParser.PluginPropertiesListContext ctx) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (DorisStatementParser.PluginPropertyContext each : ctx.pluginProperty()) {
            String key = this.getPluginPropertyKey(each.pluginPropertyKey());
            String value = this.getPluginPropertyValue(each.pluginPropertyValue());
            result.put(key, value);
        }
        return result;
    }

    private String getPluginPropertyKey(DorisStatementParser.PluginPropertyKeyContext ctx) {
        if (null != ctx.identifier()) {
            return ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        }
        return ((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue();
    }

    private String getPluginPropertyValue(DorisStatementParser.PluginPropertyValueContext ctx) {
        if (null != ctx.identifier()) {
            return ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        }
        ASTNode result = (ASTNode)this.visit((ParseTree)ctx.literals());
        if (result instanceof LiteralValue) {
            return this.getLiteralValueAsString((LiteralValue)result);
        }
        return result.toString();
    }

    @Override
    public ASTNode visitClone(DorisStatementParser.CloneContext ctx) {
        return new MySQLCloneStatement(this.getDatabaseType(), (CloneActionSegment)this.visit((ParseTree)ctx.cloneAction()));
    }

    @Override
    public ASTNode visitCloneAction(DorisStatementParser.CloneActionContext ctx) {
        CloneActionSegment result = new CloneActionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.cloneInstance()) {
            DorisStatementParser.CloneInstanceContext cloneInstance = ctx.cloneInstance();
            CloneInstanceSegment cloneInstanceSegment = new CloneInstanceSegment(cloneInstance.start.getStartIndex(), cloneInstance.stop.getStopIndex());
            cloneInstanceSegment.setUsername(((StringLiteralValue)this.visitUsername(cloneInstance.username())).getValue());
            cloneInstanceSegment.setHostname(((StringLiteralValue)this.visit((ParseTree)cloneInstance.hostname())).getValue());
            cloneInstanceSegment.setPort(new NumberLiteralValue(cloneInstance.port().NUMBER_().getText()).getValue().intValue());
            cloneInstanceSegment.setPassword(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            if (null != ctx.SSL() && null == ctx.NO()) {
                cloneInstanceSegment.setSslRequired(true);
            }
            result.setCloneInstance(cloneInstanceSegment);
        }
        if (null != ctx.cloneDir()) {
            result.setCloneDir(((StringLiteralValue)this.visit((ParseTree)ctx.cloneDir())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitOptimizeTable(DorisStatementParser.OptimizeTableContext ctx) {
        return new MySQLOptimizeTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitUse(DorisStatementParser.UseContext ctx) {
        return new MySQLUseStatement(this.getDatabaseType(), ((DatabaseSegment)this.visit((ParseTree)ctx.databaseName())).getIdentifier().getValue());
    }

    @Override
    public ASTNode visitSwitchCatalog(DorisStatementParser.SwitchCatalogContext ctx) {
        return new DorisSwitchStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.catalogName())).getValue());
    }

    @Override
    public ASTNode visitExplain(DorisStatementParser.ExplainContext ctx) {
        if (null == ctx.tableName()) {
            return new ExplainStatement(this.getDatabaseType(), (SQLStatement)this.getExplainableSQLStatement(ctx).orElse(null));
        }
        boolean showAll = null != ctx.ALL();
        return new MySQLDescribeStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), this.getColumnWildcard(ctx), showAll);
    }

    private Optional<SQLStatement> getExplainableSQLStatement(DorisStatementParser.ExplainContext ctx) {
        if (null != ctx.explainableStatement()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.explainableStatement()));
        }
        if (null != ctx.select()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.select()));
        }
        if (null != ctx.delete()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.delete()));
        }
        if (null != ctx.update()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.update()));
        }
        if (null != ctx.insert()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.insert()));
        }
        return Optional.empty();
    }

    private ColumnSegment getColumnWildcard(DorisStatementParser.ExplainContext ctx) {
        if (null != ctx.columnRef()) {
            return (ColumnSegment)this.visit((ParseTree)ctx.columnRef());
        }
        if (null != ctx.textString()) {
            return (ColumnSegment)this.visit((ParseTree)ctx.textString());
        }
        return null;
    }

    @Override
    public ASTNode visitExplainableStatement(DorisStatementParser.ExplainableStatementContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.replace()) {
            return (ASTNode)this.visit((ParseTree)ctx.replace());
        }
        return (ASTNode)this.visit((ParseTree)ctx.update());
    }

    @Override
    public ASTNode visitShowProcedureCode(DorisStatementParser.ShowProcedureCodeContext ctx) {
        return new MySQLShowProcedureCodeStatement(this.getDatabaseType(), (FunctionSegment)this.visit((ParseTree)ctx.functionName()));
    }

    @Override
    public ASTNode visitShowProfile(DorisStatementParser.ShowProfileContext ctx) {
        return new MySQLShowProfileStatement(this.getDatabaseType(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitShowProfiles(DorisStatementParser.ShowProfilesContext ctx) {
        return new MySQLShowProfilesStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowDatabases(DorisStatementParser.ShowDatabasesContext ctx) {
        MySQLShowDatabasesStatement result = new MySQLShowDatabasesStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowEvents(DorisStatementParser.ShowEventsContext ctx) {
        MySQLShowEventsStatement result = new MySQLShowEventsStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowTables(DorisStatementParser.ShowTablesContext ctx) {
        MySQLShowTablesStatement result = new MySQLShowTablesStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()), null != ctx.FULL());
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowTriggers(DorisStatementParser.ShowTriggersContext ctx) {
        MySQLShowTriggersStatement result = new MySQLShowTriggersStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowWhereClause(DorisStatementParser.ShowWhereClauseContext ctx) {
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public ASTNode visitShowTableStatus(DorisStatementParser.ShowTableStatusContext ctx) {
        MySQLShowTableStatusStatement result = new MySQLShowTableStatusStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowColumns(DorisStatementParser.ShowColumnsContext ctx) {
        MySQLShowColumnsStatement result = new MySQLShowColumnsStatement(this.getDatabaseType(), null == ctx.fromTable() ? null : ((FromTableSegment)this.visit((ParseTree)ctx.fromTable())).getTable(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowFilter(DorisStatementParser.ShowFilterContext ctx) {
        ShowFilterSegment result = new ShowFilterSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.showLike()) {
            result.setLike((ShowLikeSegment)this.visit((ParseTree)ctx.showLike()));
        }
        if (null != ctx.showWhereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.showWhereClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitShowIndex(DorisStatementParser.ShowIndexContext ctx) {
        return new MySQLShowIndexStatement(this.getDatabaseType(), null == ctx.fromTable() ? null : ((FromTableSegment)this.visitFromTable(ctx.fromTable())).getTable(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()));
    }

    @Override
    public ASTNode visitShowCreateTable(DorisStatementParser.ShowCreateTableContext ctx) {
        return new MySQLShowCreateTableStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitShowCreateTrigger(DorisStatementParser.ShowCreateTriggerContext ctx) {
        return new MySQLShowCreateTriggerStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.triggerName())).getValue());
    }

    @Override
    public ASTNode visitShowRelaylogEvent(DorisStatementParser.ShowRelaylogEventContext ctx) {
        return new MySQLShowRelayLogEventsStatement(this.getDatabaseType(), null == ctx.logName() ? null : ((StringLiteralValue)this.visit((ParseTree)ctx.logName().stringLiterals().string_())).getValue(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()), null == ctx.channelName() ? null : ((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
    }

    @Override
    public ASTNode visitShowFunctionCode(DorisStatementParser.ShowFunctionCodeContext ctx) {
        return new MySQLShowFunctionCodeStatement(this.getDatabaseType(), ((FunctionSegment)this.visit((ParseTree)ctx.functionName())).getFunctionName());
    }

    @Override
    public ASTNode visitShowGrants(DorisStatementParser.ShowGrantsContext ctx) {
        return new MySQLShowGrantsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowMasterStatus(DorisStatementParser.ShowMasterStatusContext ctx) {
        return new MySQLShowMasterStatusStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowSlaveHosts(DorisStatementParser.ShowSlaveHostsContext ctx) {
        return new MySQLShowSlaveHostsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowReplicaStatus(DorisStatementParser.ShowReplicaStatusContext ctx) {
        return new MySQLShowReplicaStatusStatement(this.getDatabaseType(), null == ctx.channelName() ? null : ((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
    }

    @Override
    public ASTNode visitShowSlaveStatus(DorisStatementParser.ShowSlaveStatusContext ctx) {
        return new MySQLShowSlaveStatusStatement(this.getDatabaseType(), null == ctx.channelName() ? null : ((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
    }

    @Override
    public ASTNode visitCreateResourceGroup(DorisStatementParser.CreateResourceGroupContext ctx) {
        return new MySQLCreateResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitBinlog(DorisStatementParser.BinlogContext ctx) {
        return new MySQLBinlogStatement(this.getDatabaseType(), ((StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals())).getValue());
    }

    @Override
    public ASTNode visitFromTable(DorisStatementParser.FromTableContext ctx) {
        FromTableSegment result = new FromTableSegment();
        result.setStartIndex(ctx.getStart().getStartIndex());
        result.setStopIndex(ctx.getStop().getStopIndex());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitShowVariables(DorisStatementParser.ShowVariablesContext ctx) {
        MySQLShowVariablesStatement result = new MySQLShowVariablesStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCharacterSet(DorisStatementParser.ShowCharacterSetContext ctx) {
        MySQLShowCharacterSetStatement result = new MySQLShowCharacterSetStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCollation(DorisStatementParser.ShowCollationContext ctx) {
        MySQLShowCollationStatement result = new MySQLShowCollationStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowFunctionStatus(DorisStatementParser.ShowFunctionStatusContext ctx) {
        MySQLShowFunctionStatusStatement result = new MySQLShowFunctionStatusStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitDescFunction(DorisStatementParser.DescFunctionContext ctx) {
        DorisDescFunctionStatement result = new DorisDescFunctionStatement(this.getDatabaseType());
        FunctionNameSegment functionName = new FunctionNameSegment(ctx.functionName().start.getStartIndex(), ctx.functionName().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.functionName().identifier()));
        if (null != ctx.functionName().owner()) {
            functionName.setOwner((OwnerSegment)this.visit((ParseTree)ctx.functionName().owner()));
        }
        result.setFunctionName(functionName);
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowFunctions(DorisStatementParser.ShowFunctionsContext ctx) {
        DorisShowFunctionsStatement result = new DorisShowFunctionsStatement(this.getDatabaseType());
        result.setGlobal(null != ctx.GLOBAL());
        result.setFull(null != ctx.FULL());
        result.setBuiltin(null != ctx.BUILTIN());
        if (null != ctx.fromDatabase()) {
            result.setFromDatabase((FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()));
        }
        if (null != ctx.showLike()) {
            result.setLikeSegment((ShowLikeSegment)this.visit((ParseTree)ctx.showLike()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowProcedureStatus(DorisStatementParser.ShowProcedureStatusContext ctx) {
        MySQLShowProcedureStatusStatement result = new MySQLShowProcedureStatusStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowOpenTables(DorisStatementParser.ShowOpenTablesContext ctx) {
        MySQLShowOpenTablesStatement result = new MySQLShowOpenTablesStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowPlugins(DorisStatementParser.ShowPluginsContext ctx) {
        return new MySQLShowPluginsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowPrivileges(DorisStatementParser.ShowPrivilegesContext ctx) {
        return new MySQLShowPrivilegesStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShutdown(DorisStatementParser.ShutdownContext ctx) {
        return new MySQLShutdownStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowProcesslist(DorisStatementParser.ShowProcesslistContext ctx) {
        return new MySQLShowProcessListStatement(this.getDatabaseType(), null != ctx.FULL());
    }

    @Override
    public ASTNode visitShowCreateUser(DorisStatementParser.ShowCreateUserContext ctx) {
        return new MySQLShowCreateUserStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.username())).getValue());
    }

    @Override
    public ASTNode visitSetVariable(DorisStatementParser.SetVariableContext ctx) {
        return new SetStatement(this.getDatabaseType(), this.getVariableAssigns(ctx.optionValueList()));
    }

    private List<VariableAssignSegment> getVariableAssigns(DorisStatementParser.OptionValueListContext ctx) {
        LinkedList<VariableAssignSegment> result = new LinkedList<VariableAssignSegment>();
        result.add(null == ctx.optionValueNoOptionType() ? this.getVariableAssignSegment(ctx) : this.getVariableAssignSegment(ctx.optionValueNoOptionType()));
        for (DorisStatementParser.OptionValueContext each : ctx.optionValue()) {
            result.add(this.getVariableAssignSegment(each));
        }
        return result;
    }

    private VariableAssignSegment getVariableAssignSegment(DorisStatementParser.OptionValueContext ctx) {
        if (null != ctx.optionValueNoOptionType()) {
            return this.getVariableAssignSegment(ctx.optionValueNoOptionType());
        }
        VariableSegment variable = new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText(), ctx.optionType().getText());
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), variable, ctx.setExprOrDefault().getText());
    }

    private VariableAssignSegment getVariableAssignSegment(DorisStatementParser.OptionValueListContext ctx) {
        VariableSegment variable = new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText(), ctx.optionType().getText());
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.setExprOrDefault().stop.getStopIndex(), variable, ctx.setExprOrDefault().getText());
    }

    private VariableAssignSegment getVariableAssignSegment(DorisStatementParser.OptionValueNoOptionTypeContext ctx) {
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getVariableSegment(ctx), this.getAssignValue(ctx));
    }

    private VariableSegment getVariableSegment(DorisStatementParser.OptionValueNoOptionTypeContext ctx) {
        if (null != ctx.NAMES()) {
            return new VariableSegment(ctx.NAMES().getSymbol().getStartIndex(), ctx.NAMES().getSymbol().getStopIndex(), "character_set_client");
        }
        if (null != ctx.internalVariableName()) {
            return new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText());
        }
        if (null != ctx.userVariable()) {
            return new VariableSegment(ctx.userVariable().start.getStartIndex(), ctx.userVariable().stop.getStopIndex(), ctx.userVariable().getText());
        }
        if (null != ctx.setSystemVariable()) {
            VariableSegment result = new VariableSegment(ctx.setSystemVariable().start.getStartIndex(), ctx.setSystemVariable().stop.getStopIndex(), ctx.setSystemVariable().internalVariableName().getText());
            DorisStatementParser.OptionTypeContext optionType = ctx.setSystemVariable().optionType();
            result.setScope(null == optionType ? "SESSION" : optionType.getText());
            return result;
        }
        return null;
    }

    @Override
    public ASTNode visitUnsetVariable(DorisStatementParser.UnsetVariableContext ctx) {
        String scope = null != ctx.optionType() ? ctx.optionType().getText() : "SESSION";
        String variableName = ctx.unsetVariableName().getText();
        return new UnsetVariableStatement(this.getDatabaseType(), scope, variableName);
    }

    private String getAssignValue(DorisStatementParser.OptionValueNoOptionTypeContext ctx) {
        if (null != ctx.NAMES()) {
            return ctx.charsetName().getText();
        }
        if (null != ctx.internalVariableName()) {
            return ctx.setExprOrDefault().getText();
        }
        if (null != ctx.userVariable()) {
            return ctx.expr().getText();
        }
        if (null != ctx.setSystemVariable()) {
            return ctx.setExprOrDefault().getText();
        }
        return null;
    }

    @Override
    public ASTNode visitSetCharacter(DorisStatementParser.SetCharacterContext ctx) {
        int startIndex = null == ctx.CHARSET() ? ctx.CHARACTER().getSymbol().getStartIndex() : ctx.CHARSET().getSymbol().getStartIndex();
        int stopIndex = null == ctx.CHARSET() ? ctx.SET(1).getSymbol().getStopIndex() : ctx.CHARSET().getSymbol().getStopIndex();
        VariableSegment variable = new VariableSegment(startIndex, stopIndex, null == ctx.CHARSET() ? "character_set_client" : ctx.CHARSET().getText());
        String assignValue = null == ctx.DEFAULT() ? ctx.charsetName().getText() : ctx.DEFAULT().getText();
        return new SetStatement(this.getDatabaseType(), Collections.singletonList(new VariableAssignSegment(startIndex, stopIndex, variable, assignValue)));
    }

    @Override
    public ASTNode visitFromDatabase(DorisStatementParser.FromDatabaseContext ctx) {
        return new FromDatabaseSegment(ctx.getStart().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowLike(DorisStatementParser.ShowLikeContext ctx) {
        StringLiteralValue literalValue = (StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals());
        return new ShowLikeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), literalValue.getValue());
    }

    @Override
    public ASTNode visitShowQueryStats(DorisStatementParser.ShowQueryStatsContext ctx) {
        DatabaseSegment database = null;
        FromTableSegment fromTable = null;
        if (null != ctx.databaseName()) {
            database = (DatabaseSegment)this.visit((ParseTree)ctx.databaseName());
        }
        if (null != ctx.fromTable()) {
            fromTable = (FromTableSegment)this.visit((ParseTree)ctx.fromTable());
        }
        boolean all = null != ctx.ALL();
        boolean verbose = null != ctx.VERBOSE();
        DorisShowQueryStatsStatement result = new DorisShowQueryStatsStatement(this.getDatabaseType(), database, fromTable, all, verbose);
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitCreateLoadableFunction(DorisStatementParser.CreateLoadableFunctionContext ctx) {
        return new MySQLCreateLoadableFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitInstallComponent(DorisStatementParser.InstallComponentContext ctx) {
        return new MySQLInstallComponentStatement(this.getDatabaseType(), ctx.componentName().stream().map(each -> ((StringLiteralValue)this.visit((ParseTree)each.string_())).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitUninstallComponent(DorisStatementParser.UninstallComponentContext ctx) {
        return new MySQLUninstallComponentStatement(this.getDatabaseType(), ctx.componentName().stream().map(each -> ((StringLiteralValue)this.visit((ParseTree)each.string_())).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitRestart(DorisStatementParser.RestartContext ctx) {
        return new MySQLRestartStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetResourceGroup(DorisStatementParser.SetResourceGroupContext ctx) {
        return new MySQLSetResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitCheckTable(DorisStatementParser.CheckTableContext ctx) {
        return new MySQLCheckTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitDropResourceGroup(DorisStatementParser.DropResourceGroupContext ctx) {
        return new MySQLDropResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitDropRepository(DorisStatementParser.DropRepositoryContext ctx) {
        DorisDropRepositoryStatement result = new DorisDropRepositoryStatement(this.getDatabaseType());
        DorisStatementParser.RepositoryNameContext repositoryNameCtx = ctx.repositoryName();
        IdentifierValue identifierValue = (IdentifierValue)this.visit((ParseTree)repositoryNameCtx);
        result.setRepositoryName(new RepositoryNameSegment(repositoryNameCtx.start.getStartIndex(), repositoryNameCtx.stop.getStopIndex(), identifierValue));
        return result;
    }

    @Override
    public ASTNode visitCreateRepository(DorisStatementParser.CreateRepositoryContext ctx) {
        DorisCreateRepositoryStatement result = new DorisCreateRepositoryStatement(this.getDatabaseType());
        result.setReadOnly(null != ctx.READ() && null != ctx.ONLY());
        DorisStatementParser.RepositoryNameContext repositoryNameCtx = ctx.repositoryName();
        IdentifierValue identifierValue = (IdentifierValue)this.visit((ParseTree)repositoryNameCtx);
        result.setRepositoryName(new RepositoryNameSegment(repositoryNameCtx.start.getStartIndex(), repositoryNameCtx.stop.getStopIndex(), identifierValue));
        result.setStorageType(null != ctx.S3() ? "S3" : "HDFS");
        result.setLocation(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
        result.setProperties(this.extractPropertiesSegment(ctx.propertiesClause()));
        return result;
    }

    @Override
    public ASTNode visitAlterResourceGroup(DorisStatementParser.AlterResourceGroupContext ctx) {
        return new MySQLAlterResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitAlterResource(DorisStatementParser.AlterResourceContext ctx) {
        String resourceName = this.getResourceName(ctx.resourceName());
        Properties properties = new Properties();
        for (DorisStatementParser.PropertyAssignmentContext each : ctx.propertyAssignments().propertyAssignment()) {
            String key = this.getPropertyKey(each.propertyKey());
            String value = this.getPropertyValue(each.propertyValue());
            properties.setProperty(key, value);
        }
        return new DorisAlterResourceStatement(this.getDatabaseType(), resourceName, properties);
    }

    private String getResourceName(DorisStatementParser.ResourceNameContext ctx) {
        if (null != ctx.identifier()) {
            return ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        }
        return ((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue();
    }

    private String getPropertyKey(DorisStatementParser.PropertyKeyContext ctx) {
        if (null != ctx.identifier()) {
            return ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        }
        return ((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue();
    }

    private String getPropertyValue(DorisStatementParser.PropertyValueContext ctx) {
        if (null != ctx.identifier()) {
            return ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        }
        ASTNode result = (ASTNode)this.visit((ParseTree)ctx.literals());
        if (result instanceof LiteralValue) {
            return this.getLiteralValueAsString((LiteralValue)result);
        }
        return result.toString();
    }

    private String getLiteralValueAsString(LiteralValue<?> literalValue) {
        if (literalValue instanceof StringLiteralValue) {
            return ((StringLiteralValue)literalValue).getValue();
        }
        if (literalValue instanceof NumberLiteralValue) {
            return ((NumberLiteralValue)literalValue).getValue().toString();
        }
        if (literalValue instanceof BooleanLiteralValue) {
            return String.valueOf(((BooleanLiteralValue)literalValue).getValue());
        }
        if (literalValue instanceof NullLiteralValue) {
            return "NULL";
        }
        if (literalValue instanceof DateTimeLiteralValue) {
            return ((DateTimeLiteralValue)literalValue).getValue();
        }
        if (literalValue instanceof TemporalLiteralValue) {
            return ((TemporalLiteralValue)literalValue).getValue();
        }
        if (literalValue instanceof OtherLiteralValue) {
            return String.valueOf(((OtherLiteralValue)literalValue).getValue());
        }
        return String.valueOf(literalValue.getValue());
    }

    @Override
    public ASTNode visitDorisAlterSystem(DorisStatementParser.DorisAlterSystemContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.dorisAlterSystemAction());
    }

    @Override
    public ASTNode visitDorisAlterSystemAction(DorisStatementParser.DorisAlterSystemActionContext ctx) {
        String action = this.getDorisAlterSystemAction(ctx);
        String target = SQLUtils.getExactlyValue((String)ctx.string_().getText());
        return new DorisAlterSystemStatement(this.getDatabaseType(), action, target);
    }

    private String getDorisAlterSystemAction(DorisStatementParser.DorisAlterSystemActionContext ctx) {
        if (null != ctx.FOLLOWER()) {
            return null != ctx.ADD() ? "ADD FOLLOWER" : "DROP FOLLOWER";
        }
        if (null != ctx.OBSERVER()) {
            return null != ctx.ADD() ? "ADD OBSERVER" : "DROP OBSERVER";
        }
        return "";
    }

    @Override
    public ASTNode visitCreateSqlBlockRule(DorisStatementParser.CreateSqlBlockRuleContext ctx) {
        DorisCreateSqlBlockRuleStatement result = new DorisCreateSqlBlockRuleStatement(this.getDatabaseType());
        result.setRuleName(((IdentifierValue)this.visit((ParseTree)ctx.ruleName())).getValue());
        result.setProperties(this.extractPropertiesSegment(ctx.propertiesClause()));
        return result;
    }

    @Override
    public ASTNode visitAlterSqlBlockRule(DorisStatementParser.AlterSqlBlockRuleContext ctx) {
        DorisAlterSqlBlockRuleStatement result = new DorisAlterSqlBlockRuleStatement(this.getDatabaseType());
        result.setRuleName(((IdentifierValue)this.visit((ParseTree)ctx.ruleName())).getValue());
        result.setProperties(this.extractPropertiesSegment(ctx.propertiesClause()));
        return result;
    }

    @Override
    public ASTNode visitDropSqlBlockRule(DorisStatementParser.DropSqlBlockRuleContext ctx) {
        DorisDropSqlBlockRuleStatement result = new DorisDropSqlBlockRuleStatement(this.getDatabaseType());
        for (DorisStatementParser.RuleNameContext each : ctx.ruleNames().ruleName()) {
            IdentifierValue identifier = (IdentifierValue)this.visit((ParseTree)each);
            result.getRuleNames().add(new RuleNameSegment(each.start.getStartIndex(), each.stop.getStopIndex(), identifier));
        }
        return result;
    }

    @Override
    public ASTNode visitShowSqlBlockRule(DorisStatementParser.ShowSqlBlockRuleContext ctx) {
        DorisShowSqlBlockRuleStatement result = new DorisShowSqlBlockRuleStatement(this.getDatabaseType());
        if (null != ctx.ruleName()) {
            DorisStatementParser.RuleNameContext ruleNameCtx = ctx.ruleName();
            IdentifierValue identifier = (IdentifierValue)this.visit((ParseTree)ruleNameCtx);
            result.setRuleName(new RuleNameSegment(ruleNameCtx.start.getStartIndex(), ruleNameCtx.stop.getStopIndex(), identifier));
        }
        return result;
    }

    @Override
    public ASTNode visitShowRoutineLoadTask(DorisStatementParser.ShowRoutineLoadTaskContext ctx) {
        DorisShowRoutineLoadTaskStatement result = new DorisShowRoutineLoadTaskStatement(this.getDatabaseType());
        result.setWhere((WhereSegment)this.visit((ParseTree)ctx.showWhereClause()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowRoutineLoad(DorisStatementParser.ShowRoutineLoadContext ctx) {
        DorisShowRoutineLoadStatement result = new DorisShowRoutineLoadStatement(this.getDatabaseType());
        result.setShowAll(null != ctx.ALL());
        if (null != ctx.qualifiedJobName()) {
            result.setJobName((JobNameSegment)this.visit((ParseTree)ctx.qualifiedJobName()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCreateRoutineLoad(DorisStatementParser.ShowCreateRoutineLoadContext ctx) {
        DorisShowCreateRoutineLoadStatement result = new DorisShowCreateRoutineLoadStatement(this.getDatabaseType());
        result.setAll(null != ctx.ALL());
        if (null != ctx.qualifiedJobName()) {
            result.setJobName((JobNameSegment)this.visit((ParseTree)ctx.qualifiedJobName()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitQualifiedJobName(DorisStatementParser.QualifiedJobNameContext ctx) {
        int startIndex = ctx.start.getStartIndex();
        int stopIndex = ctx.stop.getStopIndex();
        IdentifierValue identifier = new IdentifierValue(ctx.name().identifier().getText());
        DatabaseSegment database = null;
        DorisStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            IdentifierValue databaseName = new IdentifierValue(owner.identifier().getText());
            database = new DatabaseSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), databaseName);
        }
        return new JobNameSegment(startIndex, stopIndex, identifier, database);
    }

    @Override
    public ASTNode visitShowBuildIndex(DorisStatementParser.ShowBuildIndexContext ctx) {
        ShowBuildIndexStatement result = new ShowBuildIndexStatement(this.getDatabaseType());
        if (null != ctx.fromDatabase()) {
            FromDatabaseSegment fromDatabaseSegment = (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase());
            result.setDatabase(fromDatabaseSegment.getDatabase());
        }
        if (null != ctx.showWhereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.showWhereClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitShowAlterTable(DorisStatementParser.ShowAlterTableContext ctx) {
        ShowAlterTableStatement result = new ShowAlterTableStatement(this.getDatabaseType());
        if (null != ctx.COLUMN()) {
            result.setAlterType("COLUMN");
        } else if (null != ctx.ROLLUP()) {
            result.setAlterType("ROLLUP");
        }
        if (null != ctx.fromDatabase()) {
            FromDatabaseSegment fromDatabaseSegment = (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase());
            result.setDatabase(fromDatabaseSegment.getDatabase());
        }
        if (null != ctx.showWhereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.showWhereClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        return result;
    }

    private PropertiesSegment extractPropertiesSegment(DorisStatementParser.PropertiesClauseContext ctx) {
        PropertiesSegment result = new PropertiesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (DorisStatementParser.PropertyContext each : ctx.properties().property()) {
            String key = this.getPropertyKeyFromProperty(each);
            String value = this.getPropertyValueFromProperty(each);
            PropertySegment propertySegment = new PropertySegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), key, value);
            result.getProperties().add(propertySegment);
        }
        return result;
    }

    private String getPropertyKeyFromProperty(DorisStatementParser.PropertyContext ctx) {
        if (null != ctx.identifier()) {
            return ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue();
        }
        if (null != ctx.SINGLE_QUOTED_TEXT()) {
            return SQLUtils.getExactlyValue((String)ctx.SINGLE_QUOTED_TEXT().getText());
        }
        return SQLUtils.getExactlyValue((String)ctx.DOUBLE_QUOTED_TEXT().getText());
    }

    private String getPropertyValueFromProperty(DorisStatementParser.PropertyContext ctx) {
        String exactValue = SQLUtils.getExactlyValue((String)ctx.literals().getText());
        return exactValue.replace("\\\\", "\\").replace("\\\"", "\"").replace("\\'", "'");
    }

    @Override
    public ASTNode visitChangeMasterTo(DorisStatementParser.ChangeMasterToContext ctx) {
        return new MySQLChangeMasterStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitStartSlave(DorisStatementParser.StartSlaveContext ctx) {
        return new MySQLStartSlaveStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitStopSlave(DorisStatementParser.StopSlaveContext ctx) {
        return new MySQLStopSlaveStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitChangeReplicationSourceTo(DorisStatementParser.ChangeReplicationSourceToContext ctx) {
        return new MySQLChangeReplicationSourceToStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitStartReplica(DorisStatementParser.StartReplicaContext ctx) {
        return new MySQLStartReplicaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDelimiter(DorisStatementParser.DelimiterContext ctx) {
        return new MySQLDelimiterStatement(this.getDatabaseType(), ctx.delimiterName().getText());
    }

    @Override
    public ASTNode visitHelp(DorisStatementParser.HelpContext ctx) {
        return new MySQLHelpStatement(this.getDatabaseType(), ctx.textOrIdentifier().getText());
    }

    @Override
    public ASTNode visitRefresh(DorisStatementParser.RefreshContext ctx) {
        return new RefreshStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowProc(DorisStatementParser.ShowProcContext ctx) {
        String procPath = SQLUtils.getExactlyValue((String)ctx.string_().getText());
        DorisShowProcStatement result = new DorisShowProcStatement(this.getDatabaseType(), procPath);
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }
}

