/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.RowStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.utils.RowStatisticsCollectorUtils;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlRowStatisticsSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.persist.statistics.AlteredDatabaseStatistics;

public final class StatisticsStorageEngine {
    private final ContextManager contextManager;
    private final String databaseName;
    private final String schemaName;
    private final String tableName;
    private final Collection<Map<String, Object>> rowColumnValues;

    public void storage() {
        ShardingSphereTable table = this.contextManager.getDatabase(this.databaseName).getSchema(this.schemaName).getTable(this.tableName);
        TableStatistics changedTableStatistics = new TableStatistics(table.getName());
        for (Map<String, Object> each : this.rowColumnValues) {
            changedTableStatistics.getRows().add(new RowStatistics(RowStatisticsCollectorUtils.createRowValues(each, (ShardingSphereTable)table)));
        }
        AlteredDatabaseStatistics alteredDatabaseStatistics = this.createAlteredDatabaseStatistics(table, this.getCurrentTableStatistics(), changedTableStatistics);
        this.contextManager.getPersistServiceFacade().getMetaDataFacade().getStatisticsService().update(alteredDatabaseStatistics);
    }

    private TableStatistics getCurrentTableStatistics() {
        TableStatistics result = new TableStatistics(this.tableName);
        ShardingSphereStatistics currentStatistics = this.contextManager.getMetaDataContexts().getStatistics();
        if (!currentStatistics.containsDatabaseStatistics(this.databaseName)) {
            return result;
        }
        DatabaseStatistics databaseStatistics = currentStatistics.getDatabaseStatistics(this.databaseName);
        if (!databaseStatistics.containsSchemaStatistics(this.schemaName)) {
            return result;
        }
        SchemaStatistics schemaStatistics = databaseStatistics.getSchemaStatistics(this.schemaName);
        Optional.ofNullable(schemaStatistics.getTableStatistics(this.tableName)).ifPresent(optional -> result.getRows().addAll(optional.getRows()));
        return result;
    }

    private AlteredDatabaseStatistics createAlteredDatabaseStatistics(ShardingSphereTable table, TableStatistics currentTableStatistics, TableStatistics changedTableStatistics) {
        AlteredDatabaseStatistics result = new AlteredDatabaseStatistics(this.databaseName, this.schemaName, this.tableName);
        Map tableStatisticsMap = currentTableStatistics.getRows().stream().collect(Collectors.toMap(RowStatistics::getUniqueKey, Function.identity()));
        Map changedTableStatisticsMap = changedTableStatistics.getRows().stream().collect(Collectors.toMap(RowStatistics::getUniqueKey, Function.identity()));
        YamlRowStatisticsSwapper swapper = new YamlRowStatisticsSwapper(new ArrayList(table.getAllColumns()));
        for (Map.Entry entry : changedTableStatisticsMap.entrySet()) {
            if (!tableStatisticsMap.containsKey(entry.getKey())) {
                result.getAddedRows().add(swapper.swapToYamlConfiguration((RowStatistics)entry.getValue()));
                continue;
            }
            if (((RowStatistics)tableStatisticsMap.get(entry.getKey())).equals(entry.getValue())) continue;
            result.getUpdatedRows().add(swapper.swapToYamlConfiguration((RowStatistics)entry.getValue()));
        }
        for (Map.Entry entry : tableStatisticsMap.entrySet()) {
            if (changedTableStatisticsMap.containsKey(entry.getKey())) continue;
            result.getDeletedRows().add(swapper.swapToYamlConfiguration((RowStatistics)entry.getValue()));
        }
        return result;
    }

    @Generated
    public StatisticsStorageEngine(ContextManager contextManager, String databaseName, String schemaName, String tableName, Collection<Map<String, Object>> rowColumnValues) {
        this.contextManager = contextManager;
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.rowColumnValues = rowColumnValues;
    }
}

