/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.statistics;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.collector.DialectDatabaseStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.shardingsphere.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperation;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.statistics.RefreshStatisticsOperation;
import org.apache.shardingsphere.mode.manager.cluster.statistics.StatisticsStorageEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatisticsRefreshEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsRefreshEngine.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"statistics-collect-%d"));
    private final ContextManager contextManager;

    public void asyncRefresh() {
        if (InstanceType.PROXY == this.contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getType()) {
            EXECUTOR_SERVICE.execute(this::refresh);
        }
    }

    public void refresh() {
        try {
            if (((Boolean)this.contextManager.getMetaDataContexts().getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_ENABLED)).booleanValue()) {
                this.contextManager.getExclusiveOperatorEngine().operate((ExclusiveOperation)new RefreshStatisticsOperation(), 5000L, this::refreshStatistics);
            }
            this.cleanStatisticsData();
        }
        catch (Exception ex) {
            log.warn("Refresh statistics error.", (Throwable)ex);
        }
    }

    private void refreshStatistics() {
        ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
        for (ShardingSphereDatabase each : metaData.getAllDatabases()) {
            this.refreshForDatabase(metaData, each);
        }
    }

    private void refreshForDatabase(ShardingSphereMetaData metaData, ShardingSphereDatabase database) {
        for (ShardingSphereSchema each : database.getAllSchemas()) {
            this.refreshForSchema(metaData, database.getName(), each);
        }
    }

    private void refreshForSchema(ShardingSphereMetaData metaData, String databaseName, ShardingSphereSchema schema) {
        for (ShardingSphereTable each : schema.getAllTables()) {
            this.refreshForTable(metaData, databaseName, schema.getName(), each);
        }
    }

    private void refreshForTable(ShardingSphereMetaData metaData, String databaseName, String schemaName, ShardingSphereTable table) {
        try {
            Optional dialectStatisticsCollector;
            Optional optional2 = dialectStatisticsCollector = "shardingsphere".equalsIgnoreCase(schemaName) ? Optional.of(new ShardingSphereStatisticsCollector()) : DatabaseTypedSPILoader.findService(DialectDatabaseStatisticsCollector.class, (DatabaseType)metaData.getDatabase(databaseName).getProtocolType());
            if (dialectStatisticsCollector.isPresent()) {
                Optional rowColumnValues = ((DialectDatabaseStatisticsCollector)dialectStatisticsCollector.get()).collectRowColumnValues(databaseName, schemaName, table.getName(), metaData);
                rowColumnValues.ifPresent(optional -> new StatisticsStorageEngine(this.contextManager, databaseName, schemaName, table.getName(), (Collection<Map<String, Object>>)optional).storage());
            }
        }
        catch (Exception ex) {
            log.warn("Refresh {}.{}.{} statistics failed.", new Object[]{databaseName, schemaName, table.getName(), ex});
        }
    }

    private void cleanStatisticsData() {
        try {
            ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
            ShardingSphereStatistics statistics = this.contextManager.getMetaDataContexts().getStatistics();
            for (Map.Entry entry : statistics.getDatabaseStatisticsMap().entrySet()) {
                if (metaData.containsDatabase((String)entry.getKey())) continue;
                this.contextManager.getPersistServiceFacade().getMetaDataFacade().getStatisticsService().delete((String)entry.getKey());
            }
        }
        catch (Exception ex) {
            log.warn("Clean up useless statistics data failed.", (Throwable)ex);
        }
    }

    @Generated
    public StatisticsRefreshEngine(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

