/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.persist.service;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.mode.manager.cluster.exception.ReloadMetaDataContextFailedException;
import org.apache.shardingsphere.mode.manager.cluster.persist.coordinator.database.ClusterDatabaseListenerCoordinatorType;
import org.apache.shardingsphere.mode.manager.cluster.persist.coordinator.database.ClusterDatabaseListenerPersistCoordinator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.manager.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.retry.RetryExecutor;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class ClusterMetaDataManagerPersistService
implements MetaDataManagerPersistService {
    private final MetaDataContextManager metaDataContextManager;
    private final MetaDataPersistFacade metaDataPersistFacade;
    private final ClusterDatabaseListenerPersistCoordinator clusterDatabaseListenerPersistCoordinator;

    public ClusterMetaDataManagerPersistService(MetaDataContextManager metaDataContextManager, ClusterPersistRepository repository) {
        this.metaDataContextManager = metaDataContextManager;
        this.metaDataPersistFacade = metaDataContextManager.getMetaDataPersistFacade();
        this.clusterDatabaseListenerPersistCoordinator = new ClusterDatabaseListenerPersistCoordinator(repository);
    }

    public void createDatabase(String databaseName) {
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getDatabase().add(databaseName);
        this.clusterDatabaseListenerPersistCoordinator.persist(databaseName, ClusterDatabaseListenerCoordinatorType.CREATE);
        ShardingSphereDatabase reloadDatabase = this.getReloadedMetaDataContexts(originalMetaDataContexts).getMetaData().getDatabase(databaseName);
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistCreatedDatabaseSchemas(reloadDatabase);
    }

    public void dropDatabase(ShardingSphereDatabase database) {
        this.clusterDatabaseListenerPersistCoordinator.persist(database.getName(), ClusterDatabaseListenerCoordinatorType.DROP);
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getDatabase().drop(database.getName());
    }

    public void createSchema(ShardingSphereDatabase database, String schemaName) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getSchema().add(database.getName(), schemaName);
    }

    public void renameSchema(ShardingSphereDatabase database, String schemaName, String renameSchemaName) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().renameSchema(this.metaDataContextManager.getMetaDataContexts().getMetaData(), database, schemaName, renameSchemaName);
    }

    public void dropSchema(ShardingSphereDatabase database, Collection<String> schemaNames) {
        schemaNames.forEach(each -> this.dropSchema(database.getName(), (String)each));
    }

    private void dropSchema(String databaseName, String schemaName) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getSchema().drop(databaseName, schemaName);
    }

    public void createTable(ShardingSphereDatabase database, String schemaName, ShardingSphereTable table) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getTable().persist(database.getName(), schemaName, Collections.singleton(table));
        if (TableRefreshUtils.isSingleTable((String)table.getName(), (ShardingSphereDatabase)database) && TableRefreshUtils.isNeedRefresh((RuleMetaData)database.getRuleMetaData(), (String)schemaName, (String)table.getName())) {
            this.alterSingleRuleConfiguration(database, database.getRuleMetaData());
        }
    }

    public void dropTables(ShardingSphereDatabase database, String schemaName, Collection<String> tableNames) {
        boolean isNeedRefresh = TableRefreshUtils.isNeedRefresh((RuleMetaData)database.getRuleMetaData(), (String)schemaName, tableNames);
        tableNames.forEach(each -> this.metaDataPersistFacade.getDatabaseMetaDataFacade().getTable().drop(database.getName(), schemaName, each));
        if (isNeedRefresh && tableNames.stream().anyMatch(each -> TableRefreshUtils.isSingleTable((String)each, (ShardingSphereDatabase)database))) {
            this.alterSingleRuleConfiguration(database, database.getRuleMetaData());
        }
    }

    public void alterTables(ShardingSphereDatabase database, String schemaName, Collection<ShardingSphereTable> alteredTables) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getTable().persist(database.getName(), schemaName, alteredTables);
    }

    public void alterViews(ShardingSphereDatabase database, String schemaName, Collection<ShardingSphereView> alteredViews) {
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().getView().persist(database.getName(), schemaName, alteredViews);
    }

    public void dropViews(ShardingSphereDatabase database, String schemaName, Collection<String> droppedViews) {
        droppedViews.forEach(each -> this.metaDataPersistFacade.getDatabaseMetaDataFacade().getView().drop(database.getName(), schemaName, each));
    }

    public void registerStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeRegisteredProps) {
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDataSourceUnitService().persist(databaseName, toBeRegisteredProps);
        this.afterStorageUnitsAltered(databaseName, originalMetaDataContexts);
    }

    public void alterStorageUnits(ShardingSphereDatabase database, Map<String, DataSourcePoolProperties> toBeUpdatedProps) {
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDataSourceUnitService().persist(database.getName(), toBeUpdatedProps);
        this.afterStorageUnitsAltered(database.getName(), originalMetaDataContexts);
    }

    private void afterStorageUnitsAltered(String databaseName, MetaDataContexts originalMetaDataContexts) {
        MetaDataContexts reloadMetaDataContexts = this.getReloadedMetaDataContexts(originalMetaDataContexts);
        Optional.ofNullable(reloadMetaDataContexts.getStatistics().getDatabaseStatistics(databaseName)).ifPresent(optional -> optional.getSchemaStatisticsMap().forEach((schemaName, schemaStatistics) -> this.metaDataPersistFacade.getStatisticsService().persist(originalMetaDataContexts.getMetaData().getDatabase(databaseName), schemaName, schemaStatistics)));
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistReloadDatabase(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
    }

    public void unregisterStorageUnits(ShardingSphereDatabase database, Collection<String> toBeDroppedStorageUnitNames) {
        for (String each : this.getToBeDroppedResourceNames(database.getName(), toBeDroppedStorageUnitNames)) {
            String databaseName = database.getName();
            MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
            this.metaDataPersistFacade.getDataSourceUnitService().delete(database.getName(), each);
            MetaDataContexts reloadMetaDataContexts = this.getReloadedMetaDataContexts(originalMetaDataContexts);
            this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistReloadDatabase(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
            DatabaseStatistics databaseStatistics = reloadMetaDataContexts.getStatistics().getDatabaseStatistics(database.getName());
            if (null == databaseStatistics) continue;
            for (Map.Entry entry : databaseStatistics.getSchemaStatisticsMap().entrySet()) {
                this.metaDataPersistFacade.getStatisticsService().persist(originalMetaDataContexts.getMetaData().getDatabase(database.getName()), (String)entry.getKey(), (SchemaStatistics)entry.getValue());
            }
        }
    }

    private Collection<String> getToBeDroppedResourceNames(String databaseName, Collection<String> toBeDroppedResourceNames) {
        Map propsMap = this.metaDataPersistFacade.getDataSourceUnitService().load(databaseName);
        return toBeDroppedResourceNames.stream().filter(propsMap::containsKey).collect(Collectors.toList());
    }

    public void alterSingleRuleConfiguration(ShardingSphereDatabase database, RuleMetaData ruleMetaData) {
        SingleRuleConfiguration singleRuleConfig = ((SingleRule)ruleMetaData.getSingleRule(SingleRule.class)).getConfiguration();
        this.metaDataPersistFacade.getDatabaseRuleService().persist(database.getName(), Collections.singleton(singleRuleConfig));
    }

    public void alterRuleConfiguration(ShardingSphereDatabase database, RuleConfiguration toBeAlteredRuleConfig) {
        if (null == toBeAlteredRuleConfig) {
            return;
        }
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDatabaseRuleService().persist(database.getName(), Collections.singleton(toBeAlteredRuleConfig));
        MetaDataContexts reloadMetaDataContexts = this.getReloadedMetaDataContexts(originalMetaDataContexts);
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistReloadDatabase(database.getName(), reloadMetaDataContexts.getMetaData().getDatabase(database.getName()), originalMetaDataContexts.getMetaData().getDatabase(database.getName()));
    }

    public void removeRuleConfigurationItem(ShardingSphereDatabase database, RuleConfiguration toBeRemovedRuleItemConfig) {
        if (null == toBeRemovedRuleItemConfig) {
            return;
        }
        Collection<String> needReloadTables = this.getNeedReloadTables(database, toBeRemovedRuleItemConfig);
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDatabaseRuleService().delete(database.getName(), Collections.singleton(toBeRemovedRuleItemConfig));
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistAlteredTables(database.getName(), this.getReloadedMetaDataContexts(originalMetaDataContexts), needReloadTables);
    }

    private Collection<String> getNeedReloadTables(ShardingSphereDatabase originalDatabase, RuleConfiguration toBeAlteredRuleConfig) {
        if (toBeAlteredRuleConfig instanceof SingleRuleConfiguration) {
            Collection originalSingleTables = ((SingleRule)originalDatabase.getRuleMetaData().getSingleRule(SingleRule.class)).getConfiguration().getLogicTableNames();
            return toBeAlteredRuleConfig.getLogicTableNames().stream().filter(each -> !originalSingleTables.contains(each)).collect(Collectors.toList());
        }
        return toBeAlteredRuleConfig.getLogicTableNames();
    }

    public void removeRuleConfiguration(ShardingSphereDatabase database, RuleConfiguration toBeRemovedRuleConfig, String ruleType) {
        Collection<String> needReloadTables = this.getNeedReloadTables(database, toBeRemovedRuleConfig);
        MetaDataContexts originalMetaDataContexts = new MetaDataContexts(this.metaDataContextManager.getMetaDataContexts().getMetaData(), this.metaDataContextManager.getMetaDataContexts().getStatistics());
        this.metaDataPersistFacade.getDatabaseRuleService().delete(database.getName(), ruleType);
        this.metaDataPersistFacade.getDatabaseMetaDataFacade().persistAlteredTables(database.getName(), this.getReloadedMetaDataContexts(originalMetaDataContexts), needReloadTables);
    }

    public void alterGlobalRuleConfiguration(RuleConfiguration toBeAlteredRuleConfig) {
        this.metaDataPersistFacade.getGlobalRuleService().persist(Collections.singleton(toBeAlteredRuleConfig));
    }

    public void alterProperties(Properties props) {
        this.metaDataPersistFacade.getPropsService().persist(props);
    }

    private MetaDataContexts getReloadedMetaDataContexts(MetaDataContexts originalMetaDataContexts) {
        Thread.sleep(3000L);
        MetaDataContexts reloadMetaDataContexts = this.metaDataContextManager.getMetaDataContexts();
        if (reloadMetaDataContexts.getMetaData() != originalMetaDataContexts.getMetaData() && reloadMetaDataContexts.getStatistics() != originalMetaDataContexts.getStatistics()) {
            return reloadMetaDataContexts;
        }
        RetryExecutor retryExecutor = new RetryExecutor(30000L, 1000L);
        ShardingSpherePreconditions.checkState((boolean)retryExecutor.execute(arg -> this.metaDataContextManager.getMetaDataContexts() != arg, (Object)originalMetaDataContexts), ReloadMetaDataContextFailedException::new);
        return this.metaDataContextManager.getMetaDataContexts();
    }
}

