/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.type;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.spi.type.ordered.cache.OrderedServicesCache;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseLeafValueChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseNodeValueChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.datasource.StorageNodeChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.datasource.StorageUnitChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.SchemaChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.TableChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata.ViewChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule.type.NamedRuleItemConfigurationChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule.type.RuleTypeConfigurationChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule.type.UniqueRuleItemConfigurationChangedHandler;
import org.apache.shardingsphere.mode.metadata.manager.ActiveVersionChecker;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class DatabaseMetaDataChangedListener
implements DataChangedEventListener {
    private final ContextManager contextManager;
    private final Collection<DatabaseChangedHandler> handlers;

    public DatabaseMetaDataChangedListener(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.handlers = Arrays.asList(new SchemaChangedHandler(contextManager), new TableChangedHandler(contextManager), new ViewChangedHandler(contextManager), new StorageUnitChangedHandler(contextManager), new StorageNodeChangedHandler(contextManager), new NamedRuleItemConfigurationChangedHandler(contextManager), new UniqueRuleItemConfigurationChangedHandler(contextManager), new RuleTypeConfigurationChangedHandler(contextManager));
    }

    public void onChange(DataChangedEvent event) {
        Optional databaseName = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)DatabaseMetaDataNodePath.createDatabaseSearchCriteria());
        if (!databaseName.isPresent()) {
            return;
        }
        OrderedServicesCache.clearCache();
        for (DatabaseChangedHandler each : this.handlers) {
            if (!this.isSubscribed(each, (String)databaseName.get(), event)) continue;
            if (!(DataChangedEvent.Type.ADDED != event.getType() && DataChangedEvent.Type.UPDATED != event.getType() || new ActiveVersionChecker(this.contextManager.getPersistServiceFacade().getRepository()).checkSame(event))) {
                return;
            }
            each.handle((String)databaseName.get(), event);
            return;
        }
    }

    private boolean isSubscribed(DatabaseChangedHandler handler, String databaseName, DataChangedEvent event) {
        if (handler instanceof DatabaseLeafValueChangedHandler) {
            if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
                return new VersionNodePath(handler.getSubscribedNodePath(databaseName)).isActiveVersionPath(event.getKey());
            }
            return NodePathSearcher.isMatchedPath((String)event.getKey(), (NodePathSearchCriteria)new NodePathSearchCriteria(handler.getSubscribedNodePath(databaseName), false, 1)) && !new VersionNodePath(handler.getSubscribedNodePath(databaseName)).isActiveVersionPath(event.getKey()) && !new VersionNodePath(handler.getSubscribedNodePath(databaseName)).isVersionsPath(event.getKey());
        }
        if (handler instanceof DatabaseNodeValueChangedHandler) {
            return NodePathSearcher.isMatchedPath((String)event.getKey(), (NodePathSearchCriteria)new NodePathSearchCriteria(handler.getSubscribedNodePath(databaseName), false, 1));
        }
        return false;
    }
}

