/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.statistics;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlRowStatistics;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.GlobalDataChangedEventHandler;
import org.apache.shardingsphere.mode.metadata.manager.statistics.StatisticsManager;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsDataNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsDatabaseNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsSchemaNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsTableNodePath;

public final class StatisticsChangedHandler
implements GlobalDataChangedEventHandler {
    @Override
    public NodePath getSubscribedNodePath() {
        return new StatisticsDatabaseNodePath(null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        StatisticsManager statisticsManager = contextManager.getMetaDataContextManager().getStatisticsManager();
        Optional databaseName = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)StatisticsDatabaseNodePath.createDatabaseSearchCriteria((boolean)false));
        if (databaseName.isPresent()) {
            this.handleDatabaseChanged(statisticsManager, event.getType(), (String)databaseName.get());
            return;
        }
        databaseName = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)StatisticsDatabaseNodePath.createDatabaseSearchCriteria((boolean)true));
        if (!databaseName.isPresent()) {
            return;
        }
        Optional schemaName = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)StatisticsSchemaNodePath.createSchemaSearchCriteria((boolean)false));
        if (schemaName.isPresent()) {
            this.handleSchemaChanged(statisticsManager, event.getType(), (String)databaseName.get(), (String)schemaName.get());
            return;
        }
        schemaName = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)StatisticsSchemaNodePath.createSchemaSearchCriteria((boolean)true));
        if (!schemaName.isPresent()) {
            return;
        }
        Optional tableName = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)StatisticsTableNodePath.createTableSearchCriteria((boolean)false));
        if (tableName.isPresent()) {
            this.handleTableChanged(statisticsManager, event.getType(), (String)databaseName.get(), (String)schemaName.get(), (String)tableName.get());
            return;
        }
        tableName = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)StatisticsTableNodePath.createTableSearchCriteria((boolean)true));
        if (!tableName.isPresent()) {
            return;
        }
        Optional uniqueKey = NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)StatisticsDataNodePath.createRowUniqueKeySearchCriteria());
        if (uniqueKey.isPresent()) {
            this.handleRowDataChanged(statisticsManager, event.getType(), event.getValue(), (String)databaseName.get(), (String)schemaName.get(), (String)tableName.get(), (String)uniqueKey.get());
        }
    }

    private void handleDatabaseChanged(StatisticsManager statisticsManager, DataChangedEvent.Type type, String databaseName) {
        switch (type) {
            case ADDED: 
            case UPDATED: {
                statisticsManager.addDatabaseStatistics(databaseName);
                return;
            }
            case DELETED: {
                statisticsManager.dropDatabaseStatistics(databaseName);
                return;
            }
        }
    }

    private void handleSchemaChanged(StatisticsManager statisticsManager, DataChangedEvent.Type type, String databaseName, String schemaName) {
        switch (type) {
            case ADDED: 
            case UPDATED: {
                statisticsManager.addSchemaStatistics(databaseName, schemaName);
                return;
            }
            case DELETED: {
                statisticsManager.dropSchemaStatistics(databaseName, schemaName);
                return;
            }
        }
    }

    private void handleTableChanged(StatisticsManager statisticsManager, DataChangedEvent.Type type, String databaseName, String schemaName, String tableName) {
        switch (type) {
            case ADDED: 
            case UPDATED: {
                statisticsManager.addTableStatistics(databaseName, schemaName, tableName);
                return;
            }
            case DELETED: {
                statisticsManager.dropTableStatistics(databaseName, schemaName, tableName);
                return;
            }
        }
    }

    private void handleRowDataChanged(StatisticsManager statisticsManager, DataChangedEvent.Type type, String eventValue, String databaseName, String schemaName, String tableName, String uniqueKey) {
        if (!(DataChangedEvent.Type.ADDED != type && DataChangedEvent.Type.UPDATED != type || Strings.isNullOrEmpty((String)eventValue))) {
            statisticsManager.alterRowStatistics(databaseName, schemaName, tableName, (YamlRowStatistics)YamlEngine.unmarshal((String)eventValue, YamlRowStatistics.class));
        } else if (DataChangedEvent.Type.DELETED == type) {
            statisticsManager.deleteRowStatistics(databaseName, schemaName, tableName, uniqueKey);
        }
    }
}

