/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.node.process;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockRegistry;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.GlobalDataChangedEventHandler;
import org.apache.shardingsphere.mode.manager.cluster.persist.coordinator.process.ClusterProcessPersistCoordinator;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.process.ShowProcessListTriggerNodePath;

public final class ShowProcessListHandler
implements GlobalDataChangedEventHandler {
    @Override
    public NodePath getSubscribedNodePath() {
        return new ShowProcessListTriggerNodePath(null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        if (!NodePathSearcher.isMatchedPath((String)event.getKey(), (NodePathSearchCriteria)ShowProcessListTriggerNodePath.createProcessIdSearchCriteria())) {
            return;
        }
        String instanceId = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)ShowProcessListTriggerNodePath.createInstanceIdSearchCriteria());
        String processId = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)ShowProcessListTriggerNodePath.createProcessIdSearchCriteria());
        switch (event.getType()) {
            case ADDED: {
                if (!instanceId.equals(contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId())) break;
                new ClusterProcessPersistCoordinator(contextManager.getPersistServiceFacade().getRepository()).reportLocalProcesses(instanceId, processId);
                break;
            }
            case DELETED: {
                ProcessOperationLockRegistry.getInstance().notify(processId);
                break;
            }
        }
    }
}

