/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.node.compute.type;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.instance.ClusterInstanceRegistry;
import org.apache.shardingsphere.infra.instance.ComputeNodeData;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeData;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeDataSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.node.compute.ComputeNodeChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.persist.facade.ClusterPersistServiceFacade;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.status.OnlineNodePath;

public final class ComputeNodeOnlineHandler
implements ComputeNodeChangedHandler {
    @Override
    public NodePath getSubscribedNodePath() {
        return new OnlineNodePath(null, null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        if (!NodePathSearcher.isMatchedPath((String)event.getKey(), (NodePathSearchCriteria)OnlineNodePath.createInstanceIdSearchCriteria())) {
            return;
        }
        ClusterInstanceRegistry clusterInstanceRegistry = contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry();
        InstanceType instanceType = InstanceType.valueOf((String)NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)OnlineNodePath.createInstanceTypeSearchCriteria()).toUpperCase());
        String instanceId = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)OnlineNodePath.createInstanceIdSearchCriteria());
        ComputeNodeData computeNodeData = new YamlComputeNodeDataSwapper().swapToObject((YamlComputeNodeData)YamlEngine.unmarshal((String)event.getValue(), YamlComputeNodeData.class));
        InstanceMetaData instanceMetaData = InstanceMetaDataFactory.create((String)instanceId, (InstanceType)instanceType, (ComputeNodeData)computeNodeData);
        ClusterPersistServiceFacade clusterPersistServiceFacade = (ClusterPersistServiceFacade)contextManager.getPersistServiceFacade().getModeFacade();
        switch (event.getType()) {
            case ADDED: {
                clusterInstanceRegistry.add(clusterPersistServiceFacade.getComputeNodeService().loadInstance(instanceMetaData));
                break;
            }
            case DELETED: {
                clusterInstanceRegistry.delete(new ComputeNodeInstance(instanceMetaData));
                break;
            }
        }
    }
}

