/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.node.compute.type;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.node.compute.ComputeNodeChangedHandler;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.label.LabelNodePath;

public final class ComputeNodeLabelChangedHandler
implements ComputeNodeChangedHandler {
    @Override
    public NodePath getSubscribedNodePath() {
        return new LabelNodePath(null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)LabelNodePath.createInstanceIdSearchCriteria()).ifPresent(optional -> this.handle(contextManager, event, (String)optional));
    }

    private void handle(ContextManager contextManager, DataChangedEvent event, String instanceId) {
        contextManager.getComputeNodeInstanceContext().updateLabels(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class));
    }
}

