/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseLeafValueChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.statistics.StatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.SchemaMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.ViewMetaDataNodePath;

public final class ViewChangedHandler
implements DatabaseLeafValueChangedHandler {
    private final ContextManager contextManager;
    private final StatisticsRefreshEngine statisticsRefreshEngine;

    public ViewChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.statisticsRefreshEngine = new StatisticsRefreshEngine(contextManager);
    }

    @Override
    public NodePath getSubscribedNodePath(String databaseName) {
        return new ViewMetaDataNodePath(databaseName, "([\\w-]+)", "([\\w-]+)");
    }

    @Override
    public void handle(String databaseName, DataChangedEvent event) {
        String schemaName = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)SchemaMetaDataNodePath.createSchemaSearchCriteria((String)databaseName, (boolean)true));
        String viewName = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)ViewMetaDataNodePath.createViewSearchCriteria((String)databaseName, (String)schemaName));
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                this.handleCreatedOrAltered(databaseName, schemaName, viewName);
                break;
            }
            case DELETED: {
                this.handleDropped(databaseName, schemaName, viewName);
                break;
            }
        }
    }

    private void handleCreatedOrAltered(String databaseName, String schemaName, String viewName) {
        Optional view = this.contextManager.getPersistServiceFacade().getMetaDataFacade().getDatabaseMetaDataFacade().getView().load(databaseName, schemaName, viewName);
        if (view.isPresent()) {
            this.contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().alterView(databaseName, schemaName, (ShardingSphereView)view.get());
            this.statisticsRefreshEngine.asyncRefresh();
        }
    }

    private void handleDropped(String databaseName, String schemaName, String viewName) {
        this.contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().dropView(databaseName, schemaName, viewName);
        this.statisticsRefreshEngine.asyncRefresh();
    }
}

