/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.type;

import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.TCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.SQLServerStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XABeginStatement;

public final class SQLServerTCLStatementVisitor
extends SQLServerStatementVisitor
implements TCLStatementVisitor {
    public SQLServerTCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitSetTransaction(SQLServerStatementParser.SetTransactionContext ctx) {
        return new SetTransactionStatement(this.getDatabaseType(), null, this.getTransactionIsolationLevel(ctx.isolationLevel()), null);
    }

    private TransactionIsolationLevel getTransactionIsolationLevel(SQLServerStatementParser.IsolationLevelContext ctx) {
        if (null != ctx.UNCOMMITTED()) {
            return TransactionIsolationLevel.READ_UNCOMMITTED;
        }
        if (null != ctx.COMMITTED()) {
            return TransactionIsolationLevel.READ_COMMITTED;
        }
        if (null != ctx.REPEATABLE()) {
            return TransactionIsolationLevel.REPEATABLE_READ;
        }
        if (null != ctx.SNAPSHOT()) {
            return TransactionIsolationLevel.SNAPSHOT;
        }
        return TransactionIsolationLevel.SERIALIZABLE;
    }

    @Override
    public ASTNode visitSetImplicitTransactions(SQLServerStatementParser.SetImplicitTransactionsContext ctx) {
        return new SetAutoCommitStatement(this.getDatabaseType(), "ON".equalsIgnoreCase(ctx.implicitTransactionsValue().getText()));
    }

    @Override
    public ASTNode visitBeginTransaction(SQLServerStatementParser.BeginTransactionContext ctx) {
        return new BeginTransactionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCommit(SQLServerStatementParser.CommitContext ctx) {
        return new CommitStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCommitWork(SQLServerStatementParser.CommitWorkContext ctx) {
        return new CommitStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRollback(SQLServerStatementParser.RollbackContext ctx) {
        return new RollbackStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRollbackWork(SQLServerStatementParser.RollbackWorkContext ctx) {
        return new RollbackStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSavepoint(SQLServerStatementParser.SavepointContext ctx) {
        return new SavepointStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitBeginDistributedTransaction(SQLServerStatementParser.BeginDistributedTransactionContext ctx) {
        String xid = null;
        if (null != ctx.transactionName()) {
            xid = ctx.transactionName().getText();
        } else if (null != ctx.transactionVariableName()) {
            xid = ctx.transactionVariableName().getText();
        }
        return new XABeginStatement(this.getDatabaseType(), xid);
    }
}

