/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.type;

import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.SQLServerStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.AlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.DropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.AlterSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.CreateSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.DropSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.AlterTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.CreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.DropTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.service.SQLServerAlterServiceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.service.SQLServerCreateServiceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.service.SQLServerDropServiceStatement;

public final class SQLServerDDLStatementVisitor
extends SQLServerStatementVisitor
implements DDLStatementVisitor {
    public SQLServerDDLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCreateTable(SQLServerStatementParser.CreateTableContext ctx) {
        return null == ctx.createTableClause() ? (ASTNode)this.visit((ParseTree)ctx.createTableAsSelectClause()) : (ASTNode)this.visit((ParseTree)ctx.createTableClause());
    }

    @Override
    public ASTNode visitCreateTableClause(SQLServerStatementParser.CreateTableClauseContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        CollectionValue createDefinitions = (CollectionValue)this.generateCreateDefinitionSegment(ctx.createDefinitionClause().createTableDefinitions());
        for (CreateDefinitionSegment each : createDefinitions.getValue()) {
            if (each instanceof ColumnDefinitionSegment) {
                result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                continue;
            }
            if (!(each instanceof ConstraintDefinitionSegment)) continue;
            result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
        }
        return result;
    }

    private ASTNode generateCreateDefinitionSegment(SQLServerStatementParser.CreateTableDefinitionsContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.CreateTableDefinitionContext each : ctx.createTableDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(SQLServerStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = this.isPrimaryKey(ctx);
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, false, this.getText(ctx));
        for (SQLServerStatementParser.ColumnDefinitionOptionContext columnDefinitionOptionContext : ctx.columnDefinitionOption()) {
            for (SQLServerStatementParser.ColumnConstraintContext columnConstraint : columnDefinitionOptionContext.columnConstraint()) {
                if (null == columnConstraint.columnForeignKeyConstraint()) continue;
                result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)columnConstraint.columnForeignKeyConstraint().tableName()));
            }
        }
        for (SQLServerStatementParser.ColumnConstraintContext columnConstraintContext : ctx.columnConstraints().columnConstraint()) {
            if (null == columnConstraintContext.columnForeignKeyConstraint()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)columnConstraintContext.columnForeignKeyConstraint().tableName()));
        }
        return result;
    }

    private String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    private boolean isPrimaryKey(SQLServerStatementParser.ColumnDefinitionContext ctx) {
        for (SQLServerStatementParser.ColumnDefinitionOptionContext columnDefinitionOptionContext : ctx.columnDefinitionOption()) {
            for (SQLServerStatementParser.ColumnConstraintContext columnConstraint : columnDefinitionOptionContext.columnConstraint()) {
                if (null == columnConstraint.primaryKeyConstraint() || null == columnConstraint.primaryKeyConstraint().primaryKey()) continue;
                return true;
            }
        }
        for (SQLServerStatementParser.ColumnConstraintContext columnConstraintContext : ctx.columnConstraints().columnConstraint()) {
            if (null == columnConstraintContext.primaryKeyConstraint() || null == columnConstraintContext.primaryKeyConstraint().primaryKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitTableConstraint(SQLServerStatementParser.TableConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.tablePrimaryConstraint() && null != ctx.tablePrimaryConstraint().primaryKeyUnique().primaryKey()) {
            if (null != ctx.tablePrimaryConstraint().diskTablePrimaryConstraintOption()) {
                result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tablePrimaryConstraint().diskTablePrimaryConstraintOption().columnNames())).getValue());
            }
            if (null != ctx.tablePrimaryConstraint().memoryTablePrimaryConstraintOption()) {
                result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tablePrimaryConstraint().memoryTablePrimaryConstraintOption().columnNames())).getValue());
            }
        }
        if (null != ctx.tableForeignKeyConstraint()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableForeignKeyConstraint().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(SQLServerStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        for (SQLServerStatementParser.AlterDefinitionClauseContext alterDefinitionClauseContext : ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)alterDefinitionClauseContext)).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyConstraintDefinitionSegment) {
                    result.getModifyConstraintDefinitions().add((ModifyConstraintDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof DropConstraintDefinitionSegment)) continue;
                result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(SQLServerStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.addColumnSpecification()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.addColumnSpecification())).getValue());
        }
        if (null != ctx.modifyColumnSpecification()) {
            result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)ctx.modifyColumnSpecification()));
        }
        if (null != ctx.alterDrop() && null != ctx.alterDrop().dropColumnSpecification()) {
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)ctx.alterDrop().dropColumnSpecification()));
        }
        if (null != ctx.alterDrop() && null != ctx.alterDrop().alterTableDropConstraint()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.alterDrop().alterTableDropConstraint()));
        }
        if (null != ctx.alterCheckConstraint()) {
            result.getValue().add((AlterDefinitionSegment)this.visit((ParseTree)ctx.alterCheckConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(SQLServerStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.alterColumnAddOptions()) {
            for (SQLServerStatementParser.AlterColumnAddOptionContext each : ctx.alterColumnAddOptions().alterColumnAddOption()) {
                if (null == each.columnDefinition()) continue;
                AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(each.columnDefinition().getStart().getStartIndex(), each.columnDefinition().getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition())));
                result.getValue().add(addColumnDefinition);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(SQLServerStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.alterColumnOperation().columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false, this.getText(ctx));
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(SQLServerStatementParser.DropColumnSpecificationContext ctx) {
        LinkedList<ColumnSegment> columns = new LinkedList<ColumnSegment>();
        for (SQLServerStatementParser.ColumnNameContext each : ctx.columnName()) {
            columns.add((ColumnSegment)this.visit((ParseTree)each));
        }
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitDropTable(SQLServerStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement(this.getDatabaseType());
        result.setContainsCascade(null != ctx.ifExists());
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(SQLServerStatementParser.TruncateTableContext ctx) {
        return new TruncateStatement(this.getDatabaseType(), Collections.singleton((SimpleTableSegment)this.visit((ParseTree)ctx.tableName())));
    }

    @Override
    public ASTNode visitCreateIndex(SQLServerStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnNamesWithSort())).getValue());
        return result;
    }

    @Override
    public ASTNode visitColumnNameWithSort(SQLServerStatementParser.ColumnNameWithSortContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.columnName());
    }

    @Override
    public ASTNode visitAlterIndex(SQLServerStatementParser.AlterIndexContext ctx) {
        AlterIndexStatement result = new AlterIndexStatement(this.getDatabaseType());
        if (null != ctx.indexName()) {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(SQLServerStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getIndexes().add((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitAlterCheckConstraint(SQLServerStatementParser.AlterCheckConstraintContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterTableDropConstraint(SQLServerStatementParser.AlterTableDropConstraintContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.DropConstraintNameContext each : ctx.dropConstraintName()) {
            result.getValue().add(new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)each.constraintName())));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDatabase(SQLServerStatementParser.CreateDatabaseContext ctx) {
        return new CreateDatabaseStatement(this.getDatabaseType(), ctx.databaseName().getText(), false);
    }

    @Override
    public ASTNode visitCreateFunction(SQLServerStatementParser.CreateFunctionContext ctx) {
        return new CreateFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateProcedure(SQLServerStatementParser.CreateProcedureContext ctx) {
        return new CreateProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateView(SQLServerStatementParser.CreateViewContext ctx) {
        CreateViewStatement result = new CreateViewStatement(this.getDatabaseType());
        result.setReplaceView(null != ctx.ALTER());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.createOrAlterViewClause().select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.createOrAlterViewClause().select()));
        return result;
    }

    @Override
    public ASTNode visitCreateTrigger(SQLServerStatementParser.CreateTriggerContext ctx) {
        return new CreateTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateSequence(SQLServerStatementParser.CreateSequenceContext ctx) {
        return new CreateSequenceStatement(this.getDatabaseType(), ctx.sequenceName().name().getText());
    }

    @Override
    public ASTNode visitCreateSchema(SQLServerStatementParser.CreateSchemaContext ctx) {
        return new CreateSchemaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateService(SQLServerStatementParser.CreateServiceContext ctx) {
        return new SQLServerCreateServiceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterSchema(SQLServerStatementParser.AlterSchemaContext ctx) {
        return new AlterSchemaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterService(SQLServerStatementParser.AlterServiceContext ctx) {
        return new SQLServerAlterServiceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropSchema(SQLServerStatementParser.DropSchemaContext ctx) {
        return new DropSchemaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropService(SQLServerStatementParser.DropServiceContext ctx) {
        return new SQLServerDropServiceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTrigger(SQLServerStatementParser.AlterTriggerContext ctx) {
        return new AlterTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterSequence(SQLServerStatementParser.AlterSequenceContext ctx) {
        return new AlterSequenceStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitAlterProcedure(SQLServerStatementParser.AlterProcedureContext ctx) {
        return new AlterProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterFunction(SQLServerStatementParser.AlterFunctionContext ctx) {
        return new AlterFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterView(SQLServerStatementParser.AlterViewContext ctx) {
        AlterViewStatement result = new AlterViewStatement(this.getDatabaseType());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.createOrAlterViewClause().select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.createOrAlterViewClause().select()));
        return result;
    }

    @Override
    public ASTNode visitAlterDatabase(SQLServerStatementParser.AlterDatabaseContext ctx) {
        return new AlterDatabaseStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDatabase(SQLServerStatementParser.DropDatabaseContext ctx) {
        return new DropDatabaseStatement(this.getDatabaseType(), null, false);
    }

    @Override
    public ASTNode visitDropFunction(SQLServerStatementParser.DropFunctionContext ctx) {
        return new DropFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropProcedure(SQLServerStatementParser.DropProcedureContext ctx) {
        return new DropProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropView(SQLServerStatementParser.DropViewContext ctx) {
        DropViewStatement result = new DropViewStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        for (SQLServerStatementParser.ViewNameContext each : ctx.viewName()) {
            result.getViews().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitDropTrigger(SQLServerStatementParser.DropTriggerContext ctx) {
        return new DropTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropSequence(SQLServerStatementParser.DropSequenceContext ctx) {
        return new DropSequenceStatement(this.getDatabaseType(), Collections.emptyList());
    }
}

