/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.firebird.metadata.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class FirebirdNonFixedLengthColumnSizeRegistry {
    private static final Map<String, Map<String, Integer>> COLUMN_SIZES = new ConcurrentHashMap<String, Map<String, Integer>>();

    public static void refreshTable(String schemaName, String tableName, Map<String, Integer> columnSizes) {
        if (null == tableName) {
            return;
        }
        String tableKey = FirebirdNonFixedLengthColumnSizeRegistry.buildTableKey(schemaName, tableName);
        if (columnSizes.isEmpty()) {
            COLUMN_SIZES.remove(tableKey);
            return;
        }
        HashMap<String, Integer> normalizedColumnSizes = new HashMap<String, Integer>(columnSizes.size(), 1.0f);
        for (Map.Entry<String, Integer> entry : columnSizes.entrySet()) {
            if (null == entry.getKey()) continue;
            normalizedColumnSizes.put(FirebirdNonFixedLengthColumnSizeRegistry.toKey(entry.getKey()), entry.getValue());
        }
        if (normalizedColumnSizes.isEmpty()) {
            COLUMN_SIZES.remove(tableKey);
            return;
        }
        COLUMN_SIZES.put(tableKey, Collections.unmodifiableMap(normalizedColumnSizes));
    }

    public static OptionalInt findColumnSize(String schemaName, String tableName, String columnName) {
        if (null == tableName || null == columnName) {
            return OptionalInt.empty();
        }
        Map<String, Integer> tableSizes = COLUMN_SIZES.get(FirebirdNonFixedLengthColumnSizeRegistry.buildTableKey(schemaName, tableName));
        if (null == tableSizes) {
            return OptionalInt.empty();
        }
        Integer columnSize = tableSizes.get(FirebirdNonFixedLengthColumnSizeRegistry.toKey(columnName));
        return null == columnSize ? OptionalInt.empty() : OptionalInt.of(columnSize);
    }

    private static String buildTableKey(String schemaName, String tableName) {
        String schemaKey = null == schemaName ? "" : FirebirdNonFixedLengthColumnSizeRegistry.toKey(schemaName);
        String logicTable = FirebirdNonFixedLengthColumnSizeRegistry.trimToLogicTableName(tableName);
        return schemaKey + "." + FirebirdNonFixedLengthColumnSizeRegistry.toKey(logicTable);
    }

    private static String trimToLogicTableName(String tableName) {
        int end;
        for (end = tableName.length() - 1; end >= 0 && !Character.isLetter(tableName.charAt(end)); --end) {
        }
        return end < 0 ? tableName : tableName.substring(0, end + 1);
    }

    private static String toKey(String value) {
        return value.toUpperCase(Locale.ENGLISH);
    }

    @Generated
    private FirebirdNonFixedLengthColumnSizeRegistry() {
    }
}

