/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.checker;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.exception.metadata.DuplicateShardingActualDataNodeException;
import org.apache.shardingsphere.sharding.exception.metadata.InvalidBindingTablesException;
import org.apache.shardingsphere.sharding.exception.metadata.ShardingTableRuleNotFoundException;
import org.apache.shardingsphere.sharding.rule.BindingTableCheckedConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public class ShardingRuleChecker {
    private final ShardingRule shardingRule;

    public void check(ShardingRuleConfiguration ruleConfig) {
        this.checkUniqueActualDataNodesInTableRules();
        this.checkBindingTableConfiguration(ruleConfig);
    }

    private void checkUniqueActualDataNodesInTableRules() {
        HashSet uniqueActualDataNodes = new HashSet(this.shardingRule.getShardingTables().size(), 1.0f);
        this.shardingRule.getShardingTables().forEach((key, value) -> this.checkUniqueActualDataNodes(uniqueActualDataNodes, (String)key, value.getActualDataNodes().iterator().next()));
    }

    private void checkUniqueActualDataNodes(Collection<DataNode> uniqueActualDataNodes, String logicTable, DataNode sampleActualDataNode) {
        ShardingSpherePreconditions.checkNotContains(uniqueActualDataNodes, (Object)sampleActualDataNode, () -> new DuplicateShardingActualDataNodeException(logicTable, sampleActualDataNode.getDataSourceName(), sampleActualDataNode.getTableName()));
        uniqueActualDataNodes.add(sampleActualDataNode);
    }

    private void checkBindingTableConfiguration(ShardingRuleConfiguration ruleConfig) {
        this.checkBindingTablesNumericSuffix(ruleConfig.getBindingTableGroups(), this.shardingRule.getShardingTables());
        BindingTableCheckedConfiguration checkedConfig = new BindingTableCheckedConfiguration(this.shardingRule.getDataSourceNames(), this.shardingRule.getShardingAlgorithms(), ruleConfig.getShardingAlgorithms(), ruleConfig.getBindingTableGroups(), this.shardingRule.getDefaultDatabaseShardingStrategyConfig(), this.shardingRule.getDefaultTableShardingStrategyConfig(), this.shardingRule.getDefaultShardingColumn());
        ShardingSpherePreconditions.checkState((boolean)this.isValidBindingTableConfiguration(this.shardingRule.getShardingTables(), checkedConfig), () -> new InvalidBindingTablesException("Invalid binding table configuration."));
    }

    private void checkBindingTablesNumericSuffix(Collection<ShardingTableReferenceRuleConfiguration> bindingTableGroups, Map<String, ShardingTable> shardingTables) {
        for (ShardingTableReferenceRuleConfiguration each : bindingTableGroups) {
            List bindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)each.getReference());
            if (bindingTables.size() <= 1) continue;
            for (String logicTable : bindingTables) {
                ShardingSpherePreconditions.checkState((boolean)this.hasValidNumericSuffix(this.getShardingTable(logicTable, shardingTables)), () -> new InvalidBindingTablesException(String.format("Alphabetical table suffixes are not supported in binding tables '%s'.", each.getReference())));
            }
        }
    }

    private boolean hasValidNumericSuffix(ShardingTable shardingTable) {
        String logicTable = shardingTable.getLogicTable();
        int logicTableLength = logicTable.length();
        for (DataNode each : shardingTable.getActualDataNodes()) {
            String tableName = each.getTableName();
            if (tableName.equalsIgnoreCase(logicTable) || tableName.length() <= logicTableLength || !tableName.regionMatches(true, 0, logicTable, 0, logicTableLength) || Character.isDigit(tableName.charAt(tableName.length() - 1))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidBindingTableConfiguration(Map<String, ShardingTable> shardingTables, BindingTableCheckedConfiguration checkedConfig) {
        for (ShardingTableReferenceRuleConfiguration each : checkedConfig.getBindingTableGroups()) {
            List bindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)each.getReference());
            if (bindingTables.size() <= 1) continue;
            Iterator iterator = bindingTables.iterator();
            ShardingTable sampleShardingTable = this.getShardingTable((String)iterator.next(), shardingTables);
            while (iterator.hasNext()) {
                ShardingTable shardingTable = this.getShardingTable((String)iterator.next(), shardingTables);
                if (!this.isValidActualDataSourceName(sampleShardingTable, shardingTable) || !this.isValidActualTableName(sampleShardingTable, shardingTable)) {
                    return false;
                }
                if (this.isBindingShardingAlgorithm(sampleShardingTable, shardingTable, true, checkedConfig) && this.isBindingShardingAlgorithm(sampleShardingTable, shardingTable, false, checkedConfig)) continue;
                return false;
            }
        }
        return true;
    }

    private ShardingTable getShardingTable(String logicTableName, Map<String, ShardingTable> shardingTables) {
        ShardingTable result = shardingTables.get(logicTableName);
        ShardingSpherePreconditions.checkNotNull((Object)result, () -> new ShardingTableRuleNotFoundException(Collections.singleton(logicTableName)));
        return result;
    }

    private boolean isValidActualDataSourceName(ShardingTable sampleShardingTable, ShardingTable shardingTable) {
        return sampleShardingTable.getActualDataSourceNames().equals(shardingTable.getActualDataSourceNames());
    }

    private boolean isValidActualTableName(ShardingTable sampleShardingTable, ShardingTable shardingTable) {
        for (String each : sampleShardingTable.getActualDataSourceNames()) {
            Collection actualTableNames;
            Collection sampleActualTableNames = sampleShardingTable.getActualTableNames(each).stream().map(actualTableName -> actualTableName.replace(sampleShardingTable.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet());
            if (sampleActualTableNames.equals(actualTableNames = (Collection)shardingTable.getActualTableNames(each).stream().map(optional -> optional.replace(shardingTable.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet()))) continue;
            return false;
        }
        return true;
    }

    private boolean isBindingShardingAlgorithm(ShardingTable sampleShardingTable, ShardingTable shardingTable, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        Optional<String> algorithmExpression1 = this.getAlgorithmExpression(sampleShardingTable, databaseAlgorithm, checkedConfig);
        Optional<String> algorithmExpression2 = this.getAlgorithmExpression(shardingTable, databaseAlgorithm, checkedConfig);
        if (algorithmExpression1.isPresent() && algorithmExpression2.isPresent()) {
            return algorithmExpression1.equals(algorithmExpression2);
        }
        AlgorithmConfiguration algorithmConfiguration1 = this.getAlgorithmConfiguration(sampleShardingTable, databaseAlgorithm, checkedConfig);
        AlgorithmConfiguration algorithmConfiguration2 = this.getAlgorithmConfiguration(shardingTable, databaseAlgorithm, checkedConfig);
        if (null == algorithmConfiguration1 && null == algorithmConfiguration2) {
            return true;
        }
        if (null == algorithmConfiguration1 || null == algorithmConfiguration2) {
            return false;
        }
        return algorithmConfiguration1.equals((Object)algorithmConfiguration2);
    }

    private AlgorithmConfiguration getAlgorithmConfiguration(ShardingTable shardingTable, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        ShardingStrategyConfiguration shardingStrategyConfig;
        ShardingStrategyConfiguration shardingStrategyConfiguration = shardingStrategyConfig = databaseAlgorithm ? this.shardingRule.getDatabaseShardingStrategyConfiguration(shardingTable) : this.shardingRule.getTableShardingStrategyConfiguration(shardingTable);
        if (null == shardingStrategyConfig) {
            return null;
        }
        return checkedConfig.getAlgorithmConfigs().get(shardingStrategyConfig.getShardingAlgorithmName());
    }

    private Optional<String> getAlgorithmExpression(ShardingTable shardingTable, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        ShardingStrategyConfiguration shardingStrategyConfig = databaseAlgorithm ? this.shardingRule.getDatabaseShardingStrategyConfiguration(shardingTable) : this.shardingRule.getTableShardingStrategyConfiguration(shardingTable);
        ShardingAlgorithm shardingAlgorithm = checkedConfig.getShardingAlgorithms().get(shardingStrategyConfig.getShardingAlgorithmName());
        String dataNodePrefix = databaseAlgorithm ? shardingTable.getDataSourceDataNode().getPrefix() : shardingTable.getTableDataNode().getPrefix();
        String shardingColumn = this.getShardingColumn(shardingStrategyConfig, this.shardingRule.getDefaultShardingColumn());
        return null == shardingAlgorithm ? Optional.empty() : shardingAlgorithm.getAlgorithmStructure(dataNodePrefix, shardingColumn);
    }

    private String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String defaultShardingColumn) {
        String shardingColumn = defaultShardingColumn;
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            shardingColumn = ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            shardingColumn = ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        return null == shardingColumn ? "" : shardingColumn;
    }

    public void checkToBeAddedDataNodes(Map<String, Collection<DataNode>> toBeAddedDataNodes, boolean isAlteration) {
        HashSet uniqueActualDataNodes = new HashSet(this.shardingRule.getShardingTables().size() + toBeAddedDataNodes.size(), 1.0f);
        this.shardingRule.getShardingTables().forEach((key, value) -> {
            if (isAlteration && toBeAddedDataNodes.containsKey(key)) {
                return;
            }
            this.checkUniqueActualDataNodes(uniqueActualDataNodes, (String)key, value.getActualDataNodes().iterator().next());
        });
        toBeAddedDataNodes.forEach((key, value) -> this.checkUniqueActualDataNodes(uniqueActualDataNodes, (String)key, (DataNode)value.iterator().next()));
    }

    @Generated
    public ShardingRuleChecker(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

