/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.yaml.config.strategy.keygen.YamlKeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlKeyGenerateStrategyConfigurationSwapper;

public final class DefaultKeyGenerateStrategyChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, KeyGenerateStrategyConfiguration> {
    public KeyGenerateStrategyConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        return new YamlKeyGenerateStrategyConfigurationSwapper().swapToObject((YamlKeyGenerateStrategyConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlKeyGenerateStrategyConfiguration.class));
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig, KeyGenerateStrategyConfiguration toBeChangedItemConfig) {
        currentRuleConfig.setDefaultKeyGenerateStrategy(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultKeyGenerateStrategy(null);
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("sharding", "default_key_generate_strategy");
    }
}

