/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.attribute;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingDataNodeRuleAttribute
implements DataNodeRuleAttribute {
    private final Map<String, ShardingTable> shardingTables;
    private final Map<String, Collection<DataNode>> tableDataNodes;

    public ShardingDataNodeRuleAttribute(Map<String, ShardingTable> shardingTables) {
        this.shardingTables = shardingTables;
        this.tableDataNodes = this.createShardingTableDataNodes(shardingTables);
    }

    private Map<String, Collection<DataNode>> createShardingTableDataNodes(Map<String, ShardingTable> shardingTables) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(shardingTables.size(), 1.0f);
        for (ShardingTable each : shardingTables.values()) {
            result.put(each.getLogicTable(), each.getActualDataNodes());
        }
        return result;
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.tableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.tableDataNodes.getOrDefault(tableName, Collections.emptyList());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return this.findShardingTable(logicTable).map(optional -> optional.getActualDataNodes().get(0).getTableName());
    }

    private Optional<ShardingTable> findShardingTable(String logicTableName) {
        return Strings.isNullOrEmpty((String)logicTableName) || !this.shardingTables.containsKey(logicTableName) ? Optional.empty() : Optional.of(this.shardingTables.get(logicTableName));
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return this.containsShardingTable(tables);
    }

    private boolean containsShardingTable(Collection<String> logicTableNames) {
        for (String each : logicTableNames) {
            if (!this.isShardingTable(each)) continue;
            return true;
        }
        return false;
    }

    private boolean isShardingTable(String logicTableName) {
        return this.shardingTables.containsKey(logicTableName);
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return this.findShardingTableByActualTable(actualTable).map(ShardingTable::getLogicTable);
    }

    private Optional<ShardingTable> findShardingTableByActualTable(String actualTableName) {
        for (ShardingTable each : this.shardingTables.values()) {
            if (!each.isExisted(actualTableName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return this.findShardingTable(logicTable).flatMap(optional -> this.findActualTableFromActualDataNode(catalog, optional.getActualDataNodes()));
    }

    private Optional<String> findActualTableFromActualDataNode(String catalog, List<DataNode> actualDataNodes) {
        return actualDataNodes.stream().filter(each -> each.getDataSourceName().equalsIgnoreCase(catalog)).findFirst().map(DataNode::getTableName);
    }

    public boolean isReplicaBasedDistribution() {
        return false;
    }
}

