/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeInfo;
import org.apache.shardingsphere.infra.datanode.DataNodeUtils;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.entry.InlineExpressionParserFactory;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.constant.ShardingTableConstants;
import org.apache.shardingsphere.sharding.exception.metadata.DataNodeGenerateException;
import org.apache.shardingsphere.sharding.exception.metadata.MissingRequiredDataNodesException;

public final class ShardingTable {
    private final String logicTable;
    private final List<DataNode> actualDataNodes;
    private final Set<String> actualTables;
    private final Map<DataNode, Integer> dataNodeIndexMap;
    private final ShardingStrategyConfiguration databaseShardingStrategyConfig;
    private final ShardingStrategyConfiguration tableShardingStrategyConfig;
    private final ShardingAuditStrategyConfiguration auditStrategyConfig;
    private final String generateKeyColumn;
    private final String keyGeneratorName;
    private final Collection<String> actualDataSourceNames = new LinkedHashSet<String>();
    private final Map<String, Collection<String>> dataSourceToTablesMap = new HashMap<String, Collection<String>>();
    private final DataNodeInfo dataSourceDataNode;
    private final DataNodeInfo tableDataNode;

    public ShardingTable(Collection<String> dataSourceNames, String logicTableName) {
        this.logicTable = logicTableName;
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataSourceNames.size(), 1.0f);
        this.actualDataNodes = this.generateDataNodes(logicTableName, dataSourceNames);
        this.actualTables = this.getActualTables();
        this.databaseShardingStrategyConfig = null;
        this.tableShardingStrategyConfig = null;
        this.auditStrategyConfig = null;
        this.generateKeyColumn = null;
        this.keyGeneratorName = null;
        this.dataSourceDataNode = this.actualDataNodes.isEmpty() ? null : this.createDataSourceDataNode(this.actualDataNodes);
        this.tableDataNode = this.actualDataNodes.isEmpty() ? null : this.createTableDataNode(this.actualDataNodes);
    }

    public ShardingTable(ShardingTableRuleConfiguration tableRuleConfig, Collection<String> dataSourceNames, String defaultGenerateKeyColumn) {
        this.logicTable = tableRuleConfig.getLogicTable();
        List dataNodes = InlineExpressionParserFactory.newInstance((String)tableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataNodes.size(), 1.0f);
        this.actualDataNodes = this.isEmptyDataNodes(dataNodes) ? this.generateDataNodes(tableRuleConfig.getLogicTable(), dataSourceNames) : this.generateDataNodes(dataNodes, dataSourceNames);
        this.actualTables = this.getActualTables();
        this.databaseShardingStrategyConfig = tableRuleConfig.getDatabaseShardingStrategy();
        this.tableShardingStrategyConfig = tableRuleConfig.getTableShardingStrategy();
        this.auditStrategyConfig = tableRuleConfig.getAuditStrategy();
        KeyGenerateStrategyConfiguration keyGeneratorConfig = tableRuleConfig.getKeyGenerateStrategy();
        this.generateKeyColumn = null == keyGeneratorConfig || Strings.isNullOrEmpty((String)keyGeneratorConfig.getColumn()) ? defaultGenerateKeyColumn : keyGeneratorConfig.getColumn();
        this.keyGeneratorName = null == keyGeneratorConfig ? null : keyGeneratorConfig.getKeyGeneratorName();
        this.dataSourceDataNode = this.actualDataNodes.isEmpty() ? null : this.createDataSourceDataNode(this.actualDataNodes);
        this.tableDataNode = this.actualDataNodes.isEmpty() ? null : this.createTableDataNode(this.actualDataNodes);
        this.checkRule(dataNodes);
    }

    public ShardingTable(ShardingAutoTableRuleConfiguration tableRuleConfig, Collection<String> dataSourceNames, ShardingAutoTableAlgorithm shardingAutoTableAlgorithm, String defaultGenerateKeyColumn) {
        this.logicTable = tableRuleConfig.getLogicTable();
        this.databaseShardingStrategyConfig = new NoneShardingStrategyConfiguration();
        this.tableShardingStrategyConfig = tableRuleConfig.getShardingStrategy();
        this.auditStrategyConfig = tableRuleConfig.getAuditStrategy();
        List<String> dataNodes = this.getDataNodes(tableRuleConfig, shardingAutoTableAlgorithm, dataSourceNames);
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataNodes.size(), 1.0f);
        this.actualDataNodes = this.isEmptyDataNodes(dataNodes) ? this.generateDataNodes(tableRuleConfig.getLogicTable(), dataSourceNames) : this.generateDataNodes(dataNodes, dataSourceNames);
        this.actualTables = this.getActualTables();
        KeyGenerateStrategyConfiguration keyGeneratorConfig = tableRuleConfig.getKeyGenerateStrategy();
        this.generateKeyColumn = null == keyGeneratorConfig || Strings.isNullOrEmpty((String)keyGeneratorConfig.getColumn()) ? defaultGenerateKeyColumn : keyGeneratorConfig.getColumn();
        this.keyGeneratorName = null == keyGeneratorConfig ? null : keyGeneratorConfig.getKeyGeneratorName();
        this.dataSourceDataNode = this.actualDataNodes.isEmpty() ? null : this.createDataSourceDataNode(this.actualDataNodes);
        this.tableDataNode = this.actualDataNodes.isEmpty() ? null : this.createTableDataNode(this.actualDataNodes);
        this.checkRule(dataNodes);
    }

    private DataNodeInfo createDataSourceDataNode(Collection<DataNode> actualDataNodes) {
        String prefix = ShardingTableConstants.DATA_NODE_SUFFIX_PATTERN.matcher(actualDataNodes.iterator().next().getDataSourceName()).replaceAll("");
        int suffixMinLength = actualDataNodes.stream().map(each -> each.getDataSourceName().length() - prefix.length()).min(Comparator.comparing(Integer::intValue)).orElse(1);
        return new DataNodeInfo(prefix, suffixMinLength, '0');
    }

    private DataNodeInfo createTableDataNode(Collection<DataNode> actualDataNodes) {
        String tableName = actualDataNodes.iterator().next().getTableName();
        String prefix = tableName.startsWith(this.logicTable) ? this.logicTable + ShardingTableConstants.DATA_NODE_SUFFIX_PATTERN.matcher(tableName.substring(this.logicTable.length())).replaceAll("") : ShardingTableConstants.DATA_NODE_SUFFIX_PATTERN.matcher(tableName).replaceAll("");
        int suffixMinLength = actualDataNodes.stream().map(each -> each.getTableName().length() - prefix.length()).min(Comparator.comparing(Integer::intValue)).orElse(1);
        return new DataNodeInfo(prefix, suffixMinLength, '0');
    }

    private List<String> getDataNodes(ShardingAutoTableRuleConfiguration tableRuleConfig, ShardingAutoTableAlgorithm shardingAlgorithm, Collection<String> dataSourceNames) {
        if (null == this.tableShardingStrategyConfig) {
            return new ArrayList<String>();
        }
        List<String> dataSources = Strings.isNullOrEmpty((String)tableRuleConfig.getActualDataSources()) ? new ArrayList<String>(dataSourceNames) : InlineExpressionParserFactory.newInstance((String)tableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return DataNodeUtils.getFormattedDataNodes((int)shardingAlgorithm.getAutoTablesAmount(), (String)this.logicTable, dataSources);
    }

    private Set<String> getActualTables() {
        return (Set)this.actualDataNodes.stream().map(DataNode::getTableName).collect(Collectors.toCollection(CaseInsensitiveSet::new));
    }

    private void addActualTable(String datasourceName, String tableName) {
        this.dataSourceToTablesMap.computeIfAbsent(datasourceName, key -> new LinkedHashSet()).add(tableName);
    }

    private boolean isEmptyDataNodes(Collection<String> dataNodes) {
        return null == dataNodes || dataNodes.isEmpty();
    }

    private List<DataNode> generateDataNodes(String logicTable, Collection<String> dataSourceNames) {
        ArrayList<DataNode> result = new ArrayList<DataNode>(dataSourceNames.size());
        int index = 0;
        for (String each : dataSourceNames) {
            DataNode dataNode = new DataNode(each, (String)null, logicTable);
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            this.actualDataSourceNames.add(each);
            this.addActualTable(dataNode.getDataSourceName(), dataNode.getTableName());
            ++index;
        }
        return result;
    }

    private List<DataNode> generateDataNodes(Collection<String> actualDataNodes, Collection<String> dataSourceNames) {
        ArrayList<DataNode> result = new ArrayList<DataNode>(actualDataNodes.size());
        int index = 0;
        for (String each : actualDataNodes) {
            DataNode dataNode = new DataNode(each);
            if (!dataSourceNames.contains(dataNode.getDataSourceName())) {
                throw new DataNodeGenerateException(each);
            }
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            this.actualDataSourceNames.add(dataNode.getDataSourceName());
            this.addActualTable(dataNode.getDataSourceName(), dataNode.getTableName());
            ++index;
        }
        return result;
    }

    public Map<String, List<DataNode>> getDataNodeGroups() {
        return DataNodeUtils.getDataNodeGroups(this.actualDataNodes);
    }

    public Collection<String> getActualTableNames(String targetDataSource) {
        return this.dataSourceToTablesMap.getOrDefault(targetDataSource, Collections.emptySet());
    }

    public int findActualTableIndex(String dataSourceName, String actualTableName) {
        return this.dataNodeIndexMap.getOrDefault(new DataNode(dataSourceName, (String)null, actualTableName), -1);
    }

    public boolean isExisted(String actualTableName) {
        return this.actualTables.contains(actualTableName);
    }

    private void checkRule(Collection<String> dataNodes) {
        ShardingSpherePreconditions.checkState((!this.isEmptyDataNodes(dataNodes) || null == this.tableShardingStrategyConfig || this.tableShardingStrategyConfig instanceof NoneShardingStrategyConfiguration ? 1 : 0) != 0, () -> new MissingRequiredDataNodesException(this.logicTable));
    }

    public Optional<String> getGenerateKeyColumn() {
        return Optional.ofNullable(this.generateKeyColumn);
    }

    @Generated
    public String getLogicTable() {
        return this.logicTable;
    }

    @Generated
    public List<DataNode> getActualDataNodes() {
        return this.actualDataNodes;
    }

    @Generated
    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfig() {
        return this.databaseShardingStrategyConfig;
    }

    @Generated
    public ShardingStrategyConfiguration getTableShardingStrategyConfig() {
        return this.tableShardingStrategyConfig;
    }

    @Generated
    public ShardingAuditStrategyConfiguration getAuditStrategyConfig() {
        return this.auditStrategyConfig;
    }

    @Generated
    public String getKeyGeneratorName() {
        return this.keyGeneratorName;
    }

    @Generated
    public Collection<String> getActualDataSourceNames() {
        return this.actualDataSourceNames;
    }

    @Generated
    public Map<String, Collection<String>> getDataSourceToTablesMap() {
        return this.dataSourceToTablesMap;
    }

    @Generated
    public DataNodeInfo getDataSourceDataNode() {
        return this.dataSourceDataNode;
    }

    @Generated
    public DataNodeInfo getTableDataNode() {
        return this.tableDataNode;
    }

    @Generated
    public String toString() {
        return "ShardingTable(logicTable=" + this.getLogicTable() + ", actualDataNodes=" + this.getActualDataNodes() + ", databaseShardingStrategyConfig=" + this.getDatabaseShardingStrategyConfig() + ", tableShardingStrategyConfig=" + this.getTableShardingStrategyConfig() + ", auditStrategyConfig=" + this.getAuditStrategyConfig() + ", generateKeyColumn=" + this.getGenerateKeyColumn() + ", keyGeneratorName=" + this.getKeyGeneratorName() + ", dataSourceToTablesMap=" + this.getDataSourceToTablesMap() + ")";
    }
}

