/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.strategy.type.hint;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.datanode.DataNodeInfo;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingValue;
import org.apache.shardingsphere.sharding.exception.metadata.MissingRequiredShardingConfigurationException;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategy;

public final class HintShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final HintShardingAlgorithm<?> shardingAlgorithm;

    public HintShardingStrategy(HintShardingAlgorithm<?> shardingAlgorithm) {
        ShardingSpherePreconditions.checkNotNull(shardingAlgorithm, () -> new MissingRequiredShardingConfigurationException("Hint sharding algorithm"));
        this.shardingColumns = new CaseInsensitiveSet();
        this.shardingAlgorithm = shardingAlgorithm;
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingConditionValue> shardingConditionValues, DataNodeInfo dataNodeInfo, ConfigurationProperties props) {
        ListShardingConditionValue shardingValue = (ListShardingConditionValue)shardingConditionValues.iterator().next();
        Collection shardingResult = this.shardingAlgorithm.doSharding(availableTargetNames, new HintShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), shardingValue.getValues()));
        return new CaseInsensitiveSet(shardingResult);
    }

    @Override
    @Generated
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }

    @Generated
    public HintShardingAlgorithm<?> getShardingAlgorithm() {
        return this.shardingAlgorithm;
    }
}

