/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.broadcast.ShardingDatabaseBroadcastRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.broadcast.ShardingInstanceBroadcastRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.broadcast.ShardingTableBroadcastRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.complex.ShardingComplexRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.ignore.ShardingIgnoreRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.unicast.ShardingUnicastRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableBroadcastRouteSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.DropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DMLStatement;

public final class ShardingRouteEngineFactory {
    public static ShardingRouteEngine newInstance(ShardingRule rule, ShardingSphereDatabase database, QueryContext queryContext, ShardingConditions shardingConditions, Collection<String> logicTableNames, ConfigurationProperties props) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof DDLStatement) {
            return queryContext.getSqlStatementContext().getSqlStatement().getAttributes().findAttribute(CursorSQLStatementAttribute.class).isPresent() ? ShardingRouteEngineFactory.getCursorRouteEngine(rule, sqlStatementContext, queryContext.getHintValueContext(), shardingConditions, logicTableNames, props) : ShardingRouteEngineFactory.getDDLRouteEngine(database, sqlStatement, logicTableNames);
        }
        if (sqlStatement instanceof DALStatement) {
            return ShardingRouteEngineFactory.getDALRouteEngine(database, sqlStatementContext.getSqlStatement(), queryContext.getConnectionContext(), logicTableNames);
        }
        if (sqlStatement instanceof DCLStatement) {
            return ShardingRouteEngineFactory.getDCLRouteEngine(database, sqlStatementContext, logicTableNames);
        }
        return ShardingRouteEngineFactory.getDQLRouteEngine(rule, sqlStatementContext, queryContext, shardingConditions, logicTableNames, props);
    }

    private static ShardingRouteEngine getDDLRouteEngine(ShardingSphereDatabase database, SQLStatement sqlStatement, Collection<String> logicTableNames) {
        boolean procedureStatement;
        boolean bl = procedureStatement = sqlStatement instanceof CreateProcedureStatement || sqlStatement instanceof AlterProcedureStatement || sqlStatement instanceof DropProcedureStatement;
        if (procedureStatement) {
            return new ShardingDatabaseBroadcastRouteEngine();
        }
        return new ShardingTableBroadcastRouteEngine(database, sqlStatement, logicTableNames);
    }

    private static ShardingRouteEngine getCursorRouteEngine(ShardingRule rule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, ShardingConditions shardingConditions, Collection<String> logicTableNames, ConfigurationProperties props) {
        boolean allBindingTables;
        boolean bl = allBindingTables = logicTableNames.size() > 1 && rule.isBindingTablesUseShardingColumnsJoin(sqlStatementContext, logicTableNames);
        if (ShardingRouteEngineFactory.isShardingStandardQuery(rule, logicTableNames, allBindingTables)) {
            return new ShardingStandardRouteEngine(ShardingRouteEngineFactory.getLogicTableName(shardingConditions, logicTableNames), shardingConditions, sqlStatementContext, hintValueContext, props);
        }
        return new ShardingIgnoreRouteEngine();
    }

    private static ShardingRouteEngine getDALRouteEngine(ShardingSphereDatabase database, SQLStatement sqlStatement, ConnectionContext connectionContext, Collection<String> logicTableNames) {
        if (sqlStatement.getAttributes().findAttribute(TableBroadcastRouteSQLStatementAttribute.class).isPresent()) {
            return new ShardingTableBroadcastRouteEngine(database, sqlStatement, logicTableNames);
        }
        return new ShardingUnicastRouteEngine(sqlStatement, logicTableNames, connectionContext);
    }

    private static ShardingRouteEngine getDCLRouteEngine(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext, Collection<String> logicTableNames) {
        return ShardingRouteEngineFactory.isDCLForSingleTable(sqlStatementContext) ? new ShardingTableBroadcastRouteEngine(database, sqlStatementContext.getSqlStatement(), logicTableNames) : new ShardingInstanceBroadcastRouteEngine(database.getResourceMetaData());
    }

    private static boolean isDCLForSingleTable(SQLStatementContext sqlStatementContext) {
        return 1 == sqlStatementContext.getTablesContext().getSimpleTables().size() && !"*".equals(((SimpleTableSegment)sqlStatementContext.getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue());
    }

    private static ShardingRouteEngine getDQLRouteEngine(ShardingRule rule, SQLStatementContext sqlStatementContext, QueryContext queryContext, ShardingConditions shardingConditions, Collection<String> logicTableNames, ConfigurationProperties props) {
        Collection tableNames = sqlStatementContext.getTablesContext().getTableNames();
        if (sqlStatementContext.getSqlStatement() instanceof DMLStatement && shardingConditions.isAlwaysFalse() || tableNames.isEmpty()) {
            return new ShardingUnicastRouteEngine(sqlStatementContext.getSqlStatement(), tableNames, queryContext.getConnectionContext());
        }
        return ShardingRouteEngineFactory.getDQLRouteEngineForShardingTable(rule, sqlStatementContext, queryContext.getHintValueContext(), shardingConditions, logicTableNames, props);
    }

    private static ShardingRouteEngine getDQLRouteEngineForShardingTable(ShardingRule rule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, ShardingConditions shardingConditions, Collection<String> logicTableNames, ConfigurationProperties props) {
        boolean allBindingTables;
        boolean bl = allBindingTables = logicTableNames.size() > 1 && rule.isBindingTablesUseShardingColumnsJoin(sqlStatementContext, logicTableNames);
        if (ShardingRouteEngineFactory.isShardingStandardQuery(rule, logicTableNames, allBindingTables)) {
            return new ShardingStandardRouteEngine(ShardingRouteEngineFactory.getLogicTableName(shardingConditions, logicTableNames), shardingConditions, sqlStatementContext, hintValueContext, props);
        }
        return new ShardingComplexRouteEngine(shardingConditions, sqlStatementContext, hintValueContext, props, logicTableNames);
    }

    private static String getLogicTableName(ShardingConditions shardingConditions, Collection<String> tableNames) {
        if (shardingConditions.getConditions().isEmpty()) {
            return tableNames.iterator().next();
        }
        ShardingCondition shardingCondition = shardingConditions.getConditions().iterator().next();
        return shardingCondition.getValues().isEmpty() ? tableNames.iterator().next() : shardingCondition.getValues().iterator().next().getTableName();
    }

    private static boolean isShardingStandardQuery(ShardingRule rule, Collection<String> logicTableNames, boolean allBindingTables) {
        return 1 == logicTableNames.size() && rule.isAllShardingTables(logicTableNames) || allBindingTables;
    }

    @Generated
    private ShardingRouteEngineFactory() {
    }
}

