/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.exception.data.NotImplementComparableValueException;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class ConditionValue {
    private final Comparable<?> value;
    private final int parameterMarkerIndex;
    private boolean isNull;

    public ConditionValue(ExpressionSegment expressionSegment, List<Object> params) {
        this.value = this.getValue(expressionSegment, params);
        this.parameterMarkerIndex = expressionSegment instanceof ParameterMarkerExpressionSegment ? ((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex() : -1;
    }

    private Comparable<?> getValue(ExpressionSegment expressionSegment, List<Object> params) {
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            return this.getValue((ParameterMarkerExpressionSegment)expressionSegment, params);
        }
        if (expressionSegment instanceof LiteralExpressionSegment) {
            return this.getValue((LiteralExpressionSegment)expressionSegment);
        }
        return null;
    }

    private Comparable<?> getValue(ParameterMarkerExpressionSegment expressionSegment, List<Object> params) {
        int parameterMarkerIndex = expressionSegment.getParameterMarkerIndex();
        if (parameterMarkerIndex < params.size()) {
            Object result = params.get(parameterMarkerIndex);
            this.isNull = null == result;
            ShardingSpherePreconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, () -> new NotImplementComparableValueException("Sharding", result));
            return (Comparable)result;
        }
        return null;
    }

    private Comparable<?> getValue(LiteralExpressionSegment expressionSegment) {
        Object result = expressionSegment.getLiterals();
        this.isNull = null == result;
        ShardingSpherePreconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, () -> new NotImplementComparableValueException("Sharding", result));
        return (Comparable)result;
    }

    public Optional<Comparable<?>> getValue() {
        return Optional.ofNullable(this.value);
    }

    public Optional<Integer> getParameterMarkerIndex() {
        return this.parameterMarkerIndex > -1 ? Optional.of(this.parameterMarkerIndex) : Optional.empty();
    }

    @Generated
    public boolean isNull() {
        return this.isNull;
    }
}

