/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.lifecycle.EntranceSQLRouter;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.cache.route.CachedShardingSQLRouter;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextCheckerFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngineFactory;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DMLStatement;

public final class ShardingSQLRouter
implements EntranceSQLRouter<ShardingRule> {
    public RouteContext createRouteContext(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule, Collection<String> tableNames, ConfigurationProperties props) {
        Optional<RouteContext> result;
        if (rule.isShardingCacheEnabled() && (result = new CachedShardingSQLRouter().loadRouteContext(this::createRouteContext0, queryContext, globalRuleMetaData, database, rule.getShardingCache(), tableNames, props)).isPresent()) {
            return result.get();
        }
        return this.createRouteContext0(queryContext, globalRuleMetaData, database, rule, tableNames, props);
    }

    private RouteContext createRouteContext0(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule, Collection<String> tableNames, ConfigurationProperties props) {
        Collection<String> logicTableNames = rule.getShardingLogicTableNames(tableNames);
        if (logicTableNames.isEmpty()) {
            return new RouteContext();
        }
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        ShardingConditions shardingConditions = this.createShardingConditions(queryContext, globalRuleMetaData, database, rule);
        if (sqlStatement instanceof DMLStatement && shardingConditions.isNeedMerge()) {
            shardingConditions.merge();
        }
        RouteContext result = ShardingRouteEngineFactory.newInstance(rule, database, queryContext, shardingConditions, logicTableNames, props).route(rule);
        this.checkRouteContext(queryContext, database, rule, props, sqlStatement, shardingConditions, result);
        return result;
    }

    private ShardingConditions createShardingConditions(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule) {
        List<ShardingCondition> shardingConditions = queryContext.getSqlStatementContext().getSqlStatement() instanceof DMLStatement || queryContext.getSqlStatementContext().getSqlStatement().getAttributes().findAttribute(CursorSQLStatementAttribute.class).isPresent() ? new ShardingConditionEngine(globalRuleMetaData, database, rule).createShardingConditions(queryContext.getSqlStatementContext(), queryContext.getParameters()) : Collections.emptyList();
        return new ShardingConditions(shardingConditions, queryContext.getSqlStatementContext(), rule);
    }

    private void checkRouteContext(QueryContext queryContext, ShardingSphereDatabase database, ShardingRule rule, ConfigurationProperties props, SQLStatement sqlStatement, ShardingConditions shardingConditions, RouteContext routeContext) {
        ShardingRouteContextCheckerFactory.newInstance(sqlStatement, shardingConditions).ifPresent(optional -> optional.check(rule, queryContext, database, props, routeContext));
    }

    public SQLRouter.Type getType() {
        return SQLRouter.Type.DATA_NODE;
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

