/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.reviser.constraint;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.constraint.ConstraintReviser;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingConstraintReviser
implements ConstraintReviser<ShardingRule> {
    private final ShardingTable shardingTable;

    public Optional<ConstraintMetaData> revise(String tableName, ConstraintMetaData originalMetaData, ShardingRule rule) {
        for (DataNode each : this.shardingTable.getActualDataNodes()) {
            String referencedTableName = originalMetaData.getReferencedTableName();
            Optional<String> logicIndexName = this.getLogicIndex(originalMetaData.getName(), each.getTableName());
            if (!logicIndexName.isPresent()) continue;
            return Optional.of(new ConstraintMetaData(logicIndexName.get(), ((DataNodeRuleAttribute)rule.getAttributes().getAttribute(DataNodeRuleAttribute.class)).findLogicTableByActualTable(referencedTableName).orElse(referencedTableName)));
        }
        return Optional.empty();
    }

    private Optional<String> getLogicIndex(String actualIndexName, String actualTableName) {
        String indexNameSuffix = "_" + actualTableName;
        return actualIndexName.endsWith(indexNameSuffix) ? Optional.of(actualIndexName.replace(indexNameSuffix, "")) : Optional.empty();
    }

    @Generated
    public ShardingConstraintReviser(ShardingTable shardingTable) {
        this.shardingTable = shardingTable;
    }
}

