/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.groupby;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.exception.data.NotImplementComparableValueException;
import org.apache.shardingsphere.sharding.merge.dql.groupby.GroupByValue;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AggregationUnitFactory;
import org.apache.shardingsphere.sharding.merge.dql.orderby.OrderByStreamMergedResult;

public final class GroupByStreamMergedResult
extends OrderByStreamMergedResult {
    private final SelectStatementContext selectStatementContext;
    private final List<Object> currentRow;
    private List<?> currentGroupByValues;

    public GroupByStreamMergedResult(Map<String, Integer> labelAndIndexMap, List<QueryResult> queryResults, SelectStatementContext selectStatementContext, ShardingSphereSchema schema) throws SQLException {
        super(queryResults, selectStatementContext, schema);
        this.selectStatementContext = selectStatementContext;
        this.currentRow = new ArrayList<Object>(labelAndIndexMap.size());
        this.currentGroupByValues = this.getOrderByValuesQueue().isEmpty() ? Collections.emptyList() : new GroupByValue(this.getCurrentQueryResult(), selectStatementContext.getGroupByContext().getItems()).getGroupValues();
    }

    @Override
    public boolean next() throws SQLException {
        this.currentRow.clear();
        if (this.getOrderByValuesQueue().isEmpty()) {
            return false;
        }
        if (this.isFirstNext()) {
            super.next();
        }
        if (this.aggregateCurrentGroupByRowAndNext()) {
            this.currentGroupByValues = new GroupByValue(this.getCurrentQueryResult(), this.selectStatementContext.getGroupByContext().getItems()).getGroupValues();
        }
        return true;
    }

    private boolean aggregateCurrentGroupByRowAndNext() throws SQLException {
        boolean result = false;
        boolean cachedRow = false;
        ImmutableMap aggregationUnitMap = Maps.toMap((Iterable)this.selectStatementContext.getProjectionsContext().getAggregationProjections(), input -> AggregationUnitFactory.create(input.getType(), input instanceof AggregationDistinctProjection, input.getSeparator().orElse(null)));
        while (this.currentGroupByValues.equals(new GroupByValue(this.getCurrentQueryResult(), this.selectStatementContext.getGroupByContext().getItems()).getGroupValues())) {
            this.aggregate((Map<AggregationProjection, AggregationUnit>)aggregationUnitMap);
            if (!cachedRow) {
                this.cacheCurrentRow();
                cachedRow = true;
            }
            if (result = super.next()) continue;
        }
        this.setAggregationValueToCurrentRow((Map<AggregationProjection, AggregationUnit>)aggregationUnitMap);
        return result;
    }

    private void aggregate(Map<AggregationProjection, AggregationUnit> aggregationUnitMap) throws SQLException {
        for (Map.Entry<AggregationProjection, AggregationUnit> entry : aggregationUnitMap.entrySet()) {
            ArrayList values = new ArrayList(2);
            if (entry.getKey().getDerivedAggregationProjections().isEmpty()) {
                values.add(this.getAggregationValue(entry.getKey()));
            } else {
                for (AggregationProjection each : entry.getKey().getDerivedAggregationProjections()) {
                    values.add(this.getAggregationValue(each));
                }
            }
            entry.getValue().merge(values);
        }
    }

    private void cacheCurrentRow() throws SQLException {
        for (int i = 0; i < this.getCurrentQueryResult().getMetaData().getColumnCount(); ++i) {
            this.currentRow.add(this.getCurrentQueryResult().getValue(i + 1, Object.class));
        }
    }

    private Comparable<?> getAggregationValue(AggregationProjection aggregationProjection) throws SQLException {
        Object result = this.getCurrentQueryResult().getValue(aggregationProjection.getIndex(), Object.class);
        ShardingSpherePreconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, () -> new NotImplementComparableValueException("Aggregation", result));
        return (Comparable)result;
    }

    private void setAggregationValueToCurrentRow(Map<AggregationProjection, AggregationUnit> aggregationUnitMap) {
        for (Map.Entry<AggregationProjection, AggregationUnit> entry : aggregationUnitMap.entrySet()) {
            this.currentRow.set(entry.getKey().getIndex() - 1, entry.getValue().getResult());
        }
    }

    public Object getValue(int columnIndex, Class<?> type) {
        Object result = this.currentRow.get(columnIndex - 1);
        this.setWasNull(null == result);
        return result;
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentRow.get(columnIndex - 1);
        this.setWasNull(null == result);
        return result;
    }
}

