/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.groupby;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.sharding.exception.data.NotImplementComparableValueException;
import org.apache.shardingsphere.sharding.merge.dql.orderby.CompareUtils;

public final class GroupByRowComparator
implements Comparator<MemoryQueryResultRow> {
    private final SelectStatementContext selectStatementContext;
    private final List<Boolean> valueCaseSensitive;

    @Override
    public int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2) {
        if (!this.selectStatementContext.getOrderByContext().getItems().isEmpty()) {
            return this.compare(o1, o2, this.selectStatementContext.getOrderByContext().getItems());
        }
        return this.compare(o1, o2, this.selectStatementContext.getGroupByContext().getItems());
    }

    private int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Object orderValue1 = o1.getCell(each.getIndex());
            ShardingSpherePreconditions.checkState((null == orderValue1 || orderValue1 instanceof Comparable ? 1 : 0) != 0, () -> new NotImplementComparableValueException("Order by", orderValue1));
            Object orderValue2 = o2.getCell(each.getIndex());
            ShardingSpherePreconditions.checkState((null == orderValue2 || orderValue2 instanceof Comparable ? 1 : 0) != 0, () -> new NotImplementComparableValueException("Order by", orderValue2));
            int result = CompareUtils.compareTo((Comparable)orderValue1, (Comparable)orderValue2, each.getSegment().getOrderDirection(), each.getSegment().getNullsOrderType(this.selectStatementContext.getSqlStatement().getDatabaseType()), this.valueCaseSensitive.get(each.getIndex()));
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    @Generated
    public GroupByRowComparator(SelectStatementContext selectStatementContext, List<Boolean> valueCaseSensitive) {
        this.selectStatementContext = selectStatementContext;
        this.valueCaseSensitive = valueCaseSensitive;
    }
}

