/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal;

import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.sharding.merge.dal.DialectShardingDALResultMerger;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingDALResultMerger
implements ResultMerger {
    private final String databaseName;
    private final ShardingRule rule;

    public MergedResult merge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext, ShardingSphereDatabase database, ConnectionContext connectionContext) throws SQLException {
        Optional<MergedResult> mergedResult;
        ShardingSphereSchema schema = this.getSchema(sqlStatementContext, database);
        Optional dialectResultMerger = DatabaseTypedSPILoader.findService(DialectShardingDALResultMerger.class, (DatabaseType)sqlStatementContext.getSqlStatement().getDatabaseType());
        if (dialectResultMerger.isPresent() && (mergedResult = ((DialectShardingDALResultMerger)dialectResultMerger.get()).merge(this.databaseName, this.rule, sqlStatementContext, schema, queryResults)).isPresent()) {
            return mergedResult.get();
        }
        return new TransparentMergedResult(queryResults.get(0));
    }

    private ShardingSphereSchema getSchema(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(database.getName());
        return sqlStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
    }

    @Generated
    public ShardingDALResultMerger(String databaseName, ShardingRule rule) {
        this.databaseName = databaseName;
        this.rule = rule;
    }
}

