/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.decider;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dal.ExplainStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.value.AlwaysFalseShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.BindingTableCheckedConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sharding.rule.checker.ShardingRuleChecker;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationDecider;

public final class ShardingSQLFederationDecider
implements SQLFederationDecider<ShardingRule> {
    public boolean decide(SQLStatementContext sqlStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule, Collection<DataNode> includedDataNodes) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return this.decide0((SelectStatementContext)sqlStatementContext, parameters, globalRuleMetaData, database, rule, includedDataNodes);
        }
        if (sqlStatementContext instanceof ExplainStatementContext) {
            ExplainStatementContext explainStatementContext = (ExplainStatementContext)sqlStatementContext;
            return this.decide(explainStatementContext.getExplainableSQLStatementContext(), parameters, globalRuleMetaData, database, rule, includedDataNodes);
        }
        throw new UnsupportedSQLOperationException(String.format("unsupported SQL statement %s in sql federation", sqlStatementContext.getSqlStatement().getClass().getSimpleName()));
    }

    private boolean decide0(SelectStatementContext selectStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule, Collection<DataNode> includedDataNodes) {
        Collection<String> tableNames = rule.getShardingLogicTableNames(selectStatementContext.getTablesContext().getTableNames());
        if (tableNames.isEmpty()) {
            return false;
        }
        this.appendTableDataNodes(rule, database, tableNames, includedDataNodes);
        boolean allShardingTables = this.isAllShardingTables(selectStatementContext, tableNames);
        if (allShardingTables && this.isSubqueryAllSameShardingConditions(selectStatementContext, parameters, globalRuleMetaData, database, rule)) {
            return false;
        }
        if (allShardingTables && this.isSingleOrJoinWithSameEqualityShardingCondition(selectStatementContext, parameters, globalRuleMetaData, database, rule, tableNames)) {
            return false;
        }
        if (selectStatementContext.isContainsSubquery() || selectStatementContext.isContainsHaving() || selectStatementContext.isContainsCombine() || selectStatementContext.isContainsPartialDistinctAggregation()) {
            return true;
        }
        if (!selectStatementContext.isContainsJoinQuery() || rule.isAllTablesInSameDataSource(tableNames)) {
            return false;
        }
        if (this.isSelfJoinWithoutShardingColumn(selectStatementContext, rule, tableNames)) {
            return true;
        }
        return tableNames.size() > 1 && !rule.isBindingTablesUseShardingColumnsJoin((SQLStatementContext)selectStatementContext, tableNames);
    }

    private boolean isSingleOrJoinWithSameEqualityShardingCondition(SelectStatementContext selectStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule, Collection<String> tableNames) {
        if (selectStatementContext.isContainsSubquery() || selectStatementContext.isContainsCombine()) {
            return false;
        }
        if (this.isConfigDatabaseAndTableShardingStrategy(tableNames, rule)) {
            return false;
        }
        ShardingConditions shardingConditions = this.createShardingConditions(selectStatementContext, parameters, globalRuleMetaData, database, rule);
        shardingConditions.merge();
        if (!shardingConditions.isSameShardingCondition()) {
            return false;
        }
        if (!this.isAllEqualitySameShardingValues(shardingConditions, tableNames)) {
            return false;
        }
        if (1 == tableNames.size() && !selectStatementContext.isContainsJoinQuery()) {
            return true;
        }
        Set<ShardingTableReferenceRuleConfiguration> bindingTableGroups = Collections.singleton(new ShardingTableReferenceRuleConfiguration("", Joiner.on((String)",").join(tableNames)));
        BindingTableCheckedConfiguration configuration = new BindingTableCheckedConfiguration(rule.getDataSourceNames(), rule.getShardingAlgorithms(), rule.getConfiguration().getShardingAlgorithms(), bindingTableGroups, rule.getDefaultDatabaseShardingStrategyConfig(), rule.getDefaultTableShardingStrategyConfig(), rule.getDefaultShardingColumn());
        return new ShardingRuleChecker(rule).isValidBindingTableConfiguration(rule.getShardingTables(), configuration);
    }

    private boolean isConfigDatabaseAndTableShardingStrategy(Collection<String> tableNames, ShardingRule rule) {
        for (String each : tableNames) {
            boolean isConfigTableShardingStrategy;
            Optional<ShardingTable> shardingTable = rule.findShardingTable(each);
            if (!shardingTable.isPresent()) continue;
            boolean isConfigDatabaseShardingStrategy = !(rule.getDatabaseShardingStrategyConfiguration(shardingTable.get()) instanceof NoneShardingStrategyConfiguration);
            boolean bl = isConfigTableShardingStrategy = !(rule.getTableShardingStrategyConfiguration(shardingTable.get()) instanceof NoneShardingStrategyConfiguration);
            if (!isConfigDatabaseShardingStrategy || !isConfigTableShardingStrategy) continue;
            return true;
        }
        return false;
    }

    private boolean isAllEqualitySameShardingValues(ShardingConditions shardingConditions, Collection<String> tableNames) {
        Object sampleValue = null;
        CaseInsensitiveSet shardingTableNames = new CaseInsensitiveSet(tableNames);
        for (ShardingCondition each : shardingConditions.getConditions()) {
            for (ShardingConditionValue value : each.getValues()) {
                if (value instanceof RangeShardingConditionValue || value instanceof AlwaysFalseShardingConditionValue) {
                    return false;
                }
                if (!(value instanceof ListShardingConditionValue)) continue;
                ListShardingConditionValue values = (ListShardingConditionValue)value;
                if (1 != values.getValues().size()) {
                    return false;
                }
                Object currentValue = values.getValues().iterator().next();
                if (null == sampleValue) {
                    sampleValue = currentValue;
                } else if (!sampleValue.equals(currentValue)) {
                    return false;
                }
                shardingTableNames.remove(value.getTableName());
            }
        }
        return shardingTableNames.isEmpty();
    }

    private boolean isSubqueryAllSameShardingConditions(SelectStatementContext selectStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule) {
        if (!selectStatementContext.isContainsSubquery()) {
            return false;
        }
        if (selectStatementContext.isContainsCombine()) {
            return false;
        }
        ShardingConditions shardingConditions = this.createShardingConditions(selectStatementContext, parameters, globalRuleMetaData, database, rule);
        return shardingConditions.isSameShardingCondition();
    }

    private boolean isAllShardingTables(SelectStatementContext selectStatementContext, Collection<String> tableNames) {
        return tableNames.size() == selectStatementContext.getTablesContext().getTableNames().size();
    }

    private ShardingConditions createShardingConditions(SelectStatementContext selectStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingRule rule) {
        List<ShardingCondition> shardingConditions = new ShardingConditionEngine(globalRuleMetaData, database, rule).createShardingConditions((SQLStatementContext)selectStatementContext, parameters);
        ShardingConditions result = new ShardingConditions(shardingConditions, (SQLStatementContext)selectStatementContext, rule);
        if (result.isNeedMerge()) {
            result.merge();
        }
        return result;
    }

    private boolean isSelfJoinWithoutShardingColumn(SelectStatementContext selectStatementContext, ShardingRule rule, Collection<String> tableNames) {
        return 1 == tableNames.size() && selectStatementContext.isContainsJoinQuery() && !rule.isBindingTablesUseShardingColumnsJoin((SQLStatementContext)selectStatementContext, tableNames);
    }

    private void appendTableDataNodes(ShardingRule rule, ShardingSphereDatabase database, Collection<String> tableNames, Collection<DataNode> includedDataNodes) {
        DataNodes dataNodes = new DataNodes(database.getRuleMetaData().getRules());
        for (String each : tableNames) {
            rule.findShardingTable(each).ifPresent(optional -> includedDataNodes.addAll(dataNodes.getDataNodes(each)));
        }
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

