/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.ddl;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.checker.sql.common.ShardingSupportedCommonChecker;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;

public final class ShardingDropTableSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof DropTableStatement;
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        DropTableStatement dropTableStatement = (DropTableStatement)sqlStatementContext.getSqlStatement();
        if (!dropTableStatement.isIfExists()) {
            ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElse(currentSchema);
            ShardingSupportedCommonChecker.checkTableExist(schema, sqlStatementContext.getTablesContext().getSimpleTables());
        }
        ShardingSpherePreconditions.checkState((!dropTableStatement.isContainsCascade() ? 1 : 0) != 0, () -> new UnsupportedShardingOperationException("DROP TABLE ... CASCADE", ((SimpleTableSegment)sqlStatementContext.getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue()));
    }
}

