/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.ddl;

import java.util.Collection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CreateViewStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.checker.sql.util.ShardingSupportedCheckUtils;
import org.apache.shardingsphere.sharding.exception.metadata.EngagedViewException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;

public final class ShardingCreateViewSupportedChecker
implements SupportedSQLChecker<CreateViewStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof CreateViewStatementContext;
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, CreateViewStatementContext sqlStatementContext) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(sqlStatementContext.getSqlStatement().getSelect());
        Collection tableSegments = extractor.getRewriteTables();
        String viewName = sqlStatementContext.getSqlStatement().getView().getTableName().getIdentifier().getValue();
        ShardingSpherePreconditions.checkState((!ShardingSupportedCheckUtils.isShardingTablesNotBindingWithView(tableSegments, rule, viewName) ? 1 : 0) != 0, () -> new EngagedViewException("sharding"));
    }
}

