/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.ddl;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.CreateProcedureStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.checker.sql.common.ShardingSupportedCommonChecker;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;

public final class ShardingCreateProcedureSupportedChecker
implements SupportedSQLChecker<CreateProcedureStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof CreateProcedureStatementContext;
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, CreateProcedureStatementContext sqlStatementContext) {
        CreateProcedureStatement createProcedureStatement = sqlStatementContext.getSqlStatement();
        Optional routineBodySegment = createProcedureStatement.getRoutineBody();
        if (!routineBodySegment.isPresent()) {
            return;
        }
        TableExtractor extractor = new TableExtractor();
        Collection existTables = extractor.extractExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get());
        ShardingSupportedCommonChecker.checkShardingTable(rule, "CREATE PROCEDURE", existTables);
        ShardingSphereSchema schema = createProcedureStatement.getProcedureName().flatMap(optional -> optional.getOwner().map(owner -> database.getSchema(owner.getIdentifier().getValue()))).orElse(currentSchema);
        ShardingSupportedCommonChecker.checkTableExist(schema, existTables);
        ShardingSupportedCommonChecker.checkTableNotExist(schema, extractor.extractNotExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get()));
    }
}

