/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.ddl;

import java.util.Arrays;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.ddl.AlterViewStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.checker.sql.util.ShardingSupportedCheckUtils;
import org.apache.shardingsphere.sharding.exception.metadata.EngagedViewException;
import org.apache.shardingsphere.sharding.exception.syntax.RenamedViewWithoutSameConfigurationException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class ShardingAlterViewSupportedChecker
implements SupportedSQLChecker<AlterViewStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof AlterViewStatementContext;
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, AlterViewStatementContext sqlStatementContext) {
        AlterViewStatement alterViewStatement = sqlStatementContext.getSqlStatement();
        Optional selectStatement = alterViewStatement.getSelect();
        String originView = alterViewStatement.getView().getTableName().getIdentifier().getValue();
        selectStatement.ifPresent(optional -> this.checkAlterViewShardingTables(rule, (SelectStatement)optional, originView));
        alterViewStatement.getRenameView().ifPresent(optional -> this.checkBroadcastShardingView(rule, originView, optional.getTableName().getIdentifier().getValue()));
    }

    private void checkAlterViewShardingTables(ShardingRule shardingRule, SelectStatement selectStatement, String viewName) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(selectStatement);
        ShardingSpherePreconditions.checkState((!ShardingSupportedCheckUtils.isShardingTablesNotBindingWithView(extractor.getRewriteTables(), shardingRule, viewName) ? 1 : 0) != 0, () -> new EngagedViewException("sharding"));
    }

    private void checkBroadcastShardingView(ShardingRule shardingRule, String originView, String targetView) {
        ShardingSpherePreconditions.checkState((!shardingRule.isShardingTable(originView) && !shardingRule.isShardingTable(targetView) || shardingRule.isAllConfigBindingTables(Arrays.asList(originView, targetView)) ? 1 : 0) != 0, () -> new RenamedViewWithoutSameConfigurationException(originView, targetView));
    }
}

