/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.config;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.keygen.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationChecker;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.expr.entry.InlineExpressionParserFactory;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.exception.metadata.MissingRequiredShardingConfigurationException;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ShardingRuleConfigurationChecker
implements DatabaseRuleConfigurationChecker<ShardingRuleConfiguration> {
    public void check(String databaseName, ShardingRuleConfiguration ruleConfig, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.checkShardingAlgorithms(ruleConfig.getShardingAlgorithms().values());
        this.checkKeyGeneratorAlgorithms(ruleConfig.getKeyGenerators().values());
        Set<String> keyGenerators = ruleConfig.getKeyGenerators().keySet();
        Set<String> auditors = ruleConfig.getAuditors().keySet();
        Set<String> shardingAlgorithms = ruleConfig.getShardingAlgorithms().keySet();
        this.checkTables(databaseName, ruleConfig.getTables(), ruleConfig.getAutoTables(), keyGenerators, auditors, shardingAlgorithms);
        this.checkKeyGenerateStrategy(databaseName, ruleConfig.getDefaultKeyGenerateStrategy(), keyGenerators);
        this.checkAuditStrategy(databaseName, ruleConfig.getDefaultAuditStrategy(), auditors);
        this.checkShardingStrategy(databaseName, ruleConfig.getDefaultDatabaseShardingStrategy(), shardingAlgorithms);
        this.checkShardingStrategy(databaseName, ruleConfig.getDefaultTableShardingStrategy(), shardingAlgorithms);
    }

    private void checkShardingAlgorithms(Collection<AlgorithmConfiguration> algorithmConfigs) {
        algorithmConfigs.forEach(each -> TypedSPILoader.checkService(ShardingAlgorithm.class, (Object)each.getType(), (Properties)each.getProps()));
    }

    private void checkKeyGeneratorAlgorithms(Collection<AlgorithmConfiguration> algorithmConfigs) {
        algorithmConfigs.stream().filter(Objects::nonNull).forEach(each -> TypedSPILoader.checkService(KeyGenerateAlgorithm.class, (Object)each.getType(), (Properties)each.getProps()));
    }

    private void checkTables(String databaseName, Collection<ShardingTableRuleConfiguration> tables, Collection<ShardingAutoTableRuleConfiguration> autoTables, Collection<String> keyGenerators, Collection<String> auditors, Collection<String> shardingAlgorithms) {
        for (ShardingTableRuleConfiguration shardingTableRuleConfiguration : tables) {
            this.checkLogicTable(databaseName, shardingTableRuleConfiguration.getLogicTable());
            this.checkKeyGenerateStrategy(databaseName, shardingTableRuleConfiguration.getKeyGenerateStrategy(), keyGenerators);
            this.checkAuditStrategy(databaseName, shardingTableRuleConfiguration.getAuditStrategy(), auditors);
            this.checkShardingStrategy(databaseName, shardingTableRuleConfiguration.getDatabaseShardingStrategy(), shardingAlgorithms);
            this.checkShardingStrategy(databaseName, shardingTableRuleConfiguration.getTableShardingStrategy(), shardingAlgorithms);
        }
        for (ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfiguration : autoTables) {
            this.checkLogicTable(databaseName, shardingAutoTableRuleConfiguration.getLogicTable());
            this.checkKeyGenerateStrategy(databaseName, shardingAutoTableRuleConfiguration.getKeyGenerateStrategy(), keyGenerators);
            this.checkAuditStrategy(databaseName, shardingAutoTableRuleConfiguration.getAuditStrategy(), auditors);
            this.checkShardingStrategy(databaseName, shardingAutoTableRuleConfiguration.getShardingStrategy(), shardingAlgorithms);
        }
    }

    private void checkLogicTable(String databaseName, String logicTable) {
        ShardingSpherePreconditions.checkNotEmpty((String)logicTable, () -> new MissingRequiredShardingConfigurationException("Sharding logic table", databaseName));
    }

    private void checkKeyGenerateStrategy(String databaseName, KeyGenerateStrategyConfiguration keyGenerateStrategy, Collection<String> keyGenerators) {
        if (null == keyGenerateStrategy) {
            return;
        }
        ShardingSpherePreconditions.checkNotEmpty((String)keyGenerateStrategy.getColumn(), () -> new MissingRequiredShardingConfigurationException("Key generate column", databaseName));
        ShardingSpherePreconditions.checkContains(keyGenerators, (Object)keyGenerateStrategy.getKeyGeneratorName(), () -> new UnregisteredAlgorithmException("Key generate", keyGenerateStrategy.getKeyGeneratorName(), new SQLExceptionIdentifier(databaseName)));
    }

    private void checkAuditStrategy(String databaseName, ShardingAuditStrategyConfiguration auditStrategy, Collection<String> auditors) {
        if (null == auditStrategy) {
            return;
        }
        ShardingSpherePreconditions.checkState((boolean)auditors.containsAll(auditStrategy.getAuditorNames()), () -> new UnregisteredAlgorithmException("Sharding audit", Joiner.on((String)",").join((Iterable)auditStrategy.getAuditorNames()), new SQLExceptionIdentifier(databaseName)));
    }

    private void checkShardingStrategy(String databaseName, ShardingStrategyConfiguration shardingStrategy, Collection<String> shardingAlgorithms) {
        if (null == shardingStrategy || shardingStrategy instanceof NoneShardingStrategyConfiguration) {
            return;
        }
        if (shardingStrategy instanceof ComplexShardingStrategyConfiguration) {
            ShardingSpherePreconditions.checkNotEmpty((String)((ComplexShardingStrategyConfiguration)shardingStrategy).getShardingColumns(), () -> new MissingRequiredShardingConfigurationException("Complex sharding columns", databaseName));
        }
        ShardingSpherePreconditions.checkNotNull((Object)shardingStrategy.getShardingAlgorithmName(), () -> new MissingRequiredShardingConfigurationException("Sharding algorithm name", databaseName));
        ShardingSpherePreconditions.checkContains(shardingAlgorithms, (Object)shardingStrategy.getShardingAlgorithmName(), () -> new UnregisteredAlgorithmException("sharding", shardingStrategy.getShardingAlgorithmName(), new SQLExceptionIdentifier(databaseName)));
    }

    public Collection<String> getRequiredDataSourceNames(ShardingRuleConfiguration ruleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ruleConfig.getTables().forEach(each -> result.addAll(this.getDataSourceNames((ShardingTableRuleConfiguration)each)));
        ruleConfig.getAutoTables().forEach(each -> result.addAll(this.getDataSourceNames((ShardingAutoTableRuleConfiguration)each)));
        return result;
    }

    private Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        List actualDataNodes = InlineExpressionParserFactory.newInstance((String)shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        return actualDataNodes.stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private Collection<String> getDataSourceNames(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        return new HashSet<String>(InlineExpressionParserFactory.newInstance((String)shardingAutoTableRuleConfig.getActualDataSources()).splitAndEvaluate());
    }

    public Collection<String> getTableNames(ShardingRuleConfiguration ruleConfig) {
        Collection result = ruleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList());
        result.addAll(ruleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        return result;
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRuleConfiguration> getTypeClass() {
        return ShardingRuleConfiguration.class;
    }
}

