/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.checker.algorithm;

import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.sharding.algorithm.sharding.mod.HashModShardingAlgorithm;
import org.apache.shardingsphere.sharding.algorithm.sharding.mod.ModShardingAlgorithm;
import org.apache.shardingsphere.sharding.algorithm.sharding.range.BoundaryBasedRangeShardingAlgorithm;
import org.apache.shardingsphere.sharding.algorithm.sharding.range.VolumeBasedRangeShardingAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class CacheableShardingAlgorithmChecker {
    private static final Collection<Class<? extends ShardingAlgorithm>> CACHEABLE_SHARDING_ALGORITHM_CLASSES = Arrays.asList(ModShardingAlgorithm.class, HashModShardingAlgorithm.class, VolumeBasedRangeShardingAlgorithm.class, BoundaryBasedRangeShardingAlgorithm.class);

    public static boolean isCacheableShardingAlgorithm(ShardingAlgorithm shardingAlgorithm) {
        return CACHEABLE_SHARDING_ALGORITHM_CLASSES.contains(shardingAlgorithm.getClass());
    }

    @Generated
    private CacheableShardingAlgorithmChecker() {
    }
}

