/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.auditor;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditor;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingSQLAuditor
implements SQLAuditor<ShardingRule> {
    public void audit(QueryContext queryContext, ShardingSphereDatabase database, ShardingRule rule) {
        Collection<ShardingAuditStrategyConfiguration> auditStrategies = this.getShardingAuditStrategies(queryContext.getSqlStatementContext(), rule);
        if (auditStrategies.isEmpty()) {
            return;
        }
        Collection disableAuditNames = queryContext.getHintValueContext().getDisableAuditNames();
        for (ShardingAuditStrategyConfiguration each : auditStrategies) {
            this.audit(queryContext, database, rule, each, disableAuditNames);
        }
    }

    private void audit(QueryContext queryContext, ShardingSphereDatabase database, ShardingRule rule, ShardingAuditStrategyConfiguration auditStrategy, Collection<String> disableAuditNames) {
        for (String each : auditStrategy.getAuditorNames()) {
            if (auditStrategy.isAllowHintDisable() && disableAuditNames.contains(each.toLowerCase())) continue;
            rule.getAuditors().get(each).check(queryContext.getSqlStatementContext(), queryContext.getParameters(), queryContext.getMetaData().getGlobalRuleMetaData(), database);
        }
    }

    private Collection<ShardingAuditStrategyConfiguration> getShardingAuditStrategies(SQLStatementContext sqlStatementContext, ShardingRule rule) {
        LinkedList<ShardingAuditStrategyConfiguration> result = new LinkedList<ShardingAuditStrategyConfiguration>();
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            rule.findShardingTable(each).ifPresent(optional -> result.add(rule.getAuditStrategyConfiguration((ShardingTable)optional)));
        }
        return result;
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

