/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.TemporalHandler;
import org.apache.shardingsphere.sharding.algorithm.sharding.datetime.temporal.TemporalHandlerFactory;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.data.InvalidDatetimeFormatException;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;

public final class IntervalShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>> {
    private static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    private static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    private static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    private static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    private static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    private static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    private String dateTimePatternString;
    private DateTimeFormatter dateTimeFormatter;
    private int dateTimePatternLength;
    private TemporalAccessor dateTimeLower;
    private TemporalAccessor dateTimeUpper;
    private DateTimeFormatter tableSuffixPattern;
    private int stepAmount;
    private ChronoUnit stepUnit;

    public void init(Properties props) {
        this.dateTimePatternString = this.getDateTimePattern(props);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateTimePatternString);
        this.dateTimePatternLength = this.dateTimePatternString.length();
        this.dateTimeLower = this.getDateTimeLower(props, this.dateTimePatternString);
        this.dateTimeUpper = this.getDateTimeUpper(props, this.dateTimePatternString);
        this.tableSuffixPattern = this.getTableSuffixPattern(props);
        this.stepAmount = Integer.parseInt(props.getOrDefault((Object)INTERVAL_AMOUNT_KEY, (Object)1).toString());
        this.stepUnit = props.containsKey(INTERVAL_UNIT_KEY) ? this.getStepUnit(props.getProperty(INTERVAL_UNIT_KEY)) : ChronoUnit.DAYS;
    }

    private String getDateTimePattern(Properties props) {
        ShardingSpherePreconditions.checkContainsKey((Map)props, (Object)DATE_TIME_PATTERN_KEY, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s can not be null", DATE_TIME_PATTERN_KEY), new Object[0]));
        return props.getProperty(DATE_TIME_PATTERN_KEY);
    }

    private TemporalAccessor getDateTimeLower(Properties props, String dateTimePattern) {
        ShardingSpherePreconditions.checkContainsKey((Map)props, (Object)DATE_TIME_LOWER_KEY, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s can not be null.", DATE_TIME_LOWER_KEY), new Object[0]));
        return this.getDateTime(DATE_TIME_LOWER_KEY, props.getProperty(DATE_TIME_LOWER_KEY), dateTimePattern);
    }

    private TemporalAccessor getDateTimeUpper(Properties props, String dateTimePattern) {
        return props.containsKey(DATE_TIME_UPPER_KEY) ? this.getDateTime(DATE_TIME_UPPER_KEY, props.getProperty(DATE_TIME_UPPER_KEY), dateTimePattern) : LocalDateTime.now();
    }

    private TemporalAccessor getDateTime(String dateTimeKey, String dateTimeValue, String dateTimePattern) {
        try {
            return this.dateTimeFormatter.parse(dateTimeValue);
        }
        catch (DateTimeParseException ignored) {
            throw new InvalidDatetimeFormatException(dateTimeKey, dateTimeValue, dateTimePattern);
        }
    }

    private DateTimeFormatter getTableSuffixPattern(Properties props) {
        String suffix = props.getProperty(SHARDING_SUFFIX_FORMAT_KEY);
        ShardingSpherePreconditions.checkNotEmpty((String)suffix, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s can not be null or empty.", SHARDING_SUFFIX_FORMAT_KEY), new Object[0]));
        return DateTimeFormatter.ofPattern(suffix);
    }

    private ChronoUnit getStepUnit(String stepUnit) {
        for (ChronoUnit each : ChronoUnit.values()) {
            if (!each.toString().equalsIgnoreCase(stepUnit)) continue;
            return each;
        }
        throw new UnsupportedSQLOperationException(String.format("Cannot find step unit for specified %s property: `%s`", INTERVAL_UNIT_KEY, stepUnit));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        ShardingSpherePreconditions.checkNotNull((Object)shardingValue.getValue(), NullShardingValueException::new);
        Range range = Range.singleton((Comparable)((Comparable)shardingValue.getValue()));
        return this.getMatchedTables(availableTargetNames, range).stream().findFirst().orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.getMatchedTables(availableTargetNames, shardingValue.getValueRange());
    }

    private <T extends TemporalAccessor & Comparable<?>> Collection<String> getMatchedTables(Collection<String> availableTargetNames, Range<Comparable<?>> range) {
        HashSet<String> result = new HashSet<String>();
        TemporalHandler temporalHandler = TemporalHandlerFactory.newInstance(this.dateTimeLower);
        Object dateTimeUpper = temporalHandler.convertTo(this.dateTimeUpper);
        Object dateTimeLower = temporalHandler.convertTo(this.dateTimeLower);
        Object calculateTimeAsView = temporalHandler.convertTo(this.dateTimeLower);
        while (!temporalHandler.isAfter(calculateTimeAsView, dateTimeUpper, this.stepAmount)) {
            if (this.hasIntersection((Range<T>)Range.closedOpen(calculateTimeAsView, temporalHandler.add(calculateTimeAsView, this.stepAmount, this.stepUnit)), range, dateTimeLower, dateTimeUpper, temporalHandler)) {
                result.addAll(this.getMatchedTables((TemporalAccessor)calculateTimeAsView, availableTargetNames, temporalHandler));
            }
            calculateTimeAsView = temporalHandler.add(calculateTimeAsView, this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private <T extends TemporalAccessor & Comparable<?>> Collection<String> getMatchedTables(TemporalAccessor calculateTimeAsView, Collection<String> availableTargetNames, TemporalHandler<T> temporalHandler) {
        return availableTargetNames.parallelStream().filter(each -> each.endsWith(this.tableSuffixPattern.format((TemporalAccessor)temporalHandler.convertTo(calculateTimeAsView)))).collect(Collectors.toSet());
    }

    private <T extends TemporalAccessor & Comparable<?>> boolean hasIntersection(Range<T> calculateRange, Range<Comparable<?>> range, T temporalLower, T temporalUpper, TemporalHandler<T> temporalHandler) {
        T lower = range.hasLowerBound() ? this.parseTemporal(range.lowerEndpoint(), temporalHandler) : temporalLower;
        T upper = range.hasUpperBound() ? this.parseTemporal(range.upperEndpoint(), temporalHandler) : temporalUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range(lower, (BoundType)lowerBoundType, upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private <T extends TemporalAccessor> T parseTemporal(Comparable<?> endpoint, TemporalHandler<T> temporalHandler) {
        String dateTimeText = this.getDateTimeText(endpoint);
        return dateTimeText.length() >= this.dateTimePatternLength ? temporalHandler.parse(dateTimeText.substring(0, this.dateTimePatternLength), this.dateTimeFormatter) : temporalHandler.parse(dateTimeText, this.createRelaxedDateTimeFormatter(dateTimeText));
    }

    private String getDateTimeText(Comparable<?> endpoint) {
        if (endpoint instanceof Instant) {
            return this.dateTimeFormatter.format(((Instant)endpoint).atZone(ZoneId.systemDefault()));
        }
        if (endpoint instanceof TemporalAccessor) {
            return this.dateTimeFormatter.format((TemporalAccessor)((Object)endpoint));
        }
        if (endpoint instanceof Date) {
            return this.dateTimeFormatter.format(((Date)endpoint).toLocalDate());
        }
        if (endpoint instanceof java.util.Date) {
            return this.dateTimeFormatter.format(((java.util.Date)endpoint).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        return endpoint.toString();
    }

    private DateTimeFormatter createRelaxedDateTimeFormatter(String dateTimeText) {
        return DateTimeFormatter.ofPattern(this.dateTimePatternString.substring(0, dateTimeText.length()));
    }

    public String getType() {
        return "INTERVAL";
    }
}

