/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.classbased;

import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.sharding.exception.algorithm.ShardingAlgorithmClassImplementationException;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ClassBasedShardingAlgorithmFactory {
    public static <T extends ShardingAlgorithm> T newInstance(String shardingAlgorithmClassName, Class<T> superShardingAlgorithmClass, Properties props) {
        Class<?> algorithmClass = ClassBasedShardingAlgorithmFactory.loadClass(shardingAlgorithmClassName);
        if (!superShardingAlgorithmClass.isAssignableFrom(algorithmClass)) {
            throw new ShardingAlgorithmClassImplementationException(shardingAlgorithmClassName, superShardingAlgorithmClass);
        }
        ShardingAlgorithm result = (ShardingAlgorithm)algorithmClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        result.init(ClassBasedShardingAlgorithmFactory.convertToStringTypedProperties(props));
        return (T)result;
    }

    private static Properties convertToStringTypedProperties(Properties props) {
        Properties result = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.setProperty(key.toString(), null == value ? null : value.toString())));
        return result;
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader[] classLoaders;
        for (ClassLoader each : classLoaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassBasedShardingAlgorithmFactory.class.getClassLoader(), ClassLoader.getSystemClassLoader()}) {
            if (null == each) continue;
            try {
                return Class.forName(className, true, each);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Could not load class: " + className);
    }

    @Generated
    private ClassBasedShardingAlgorithmFactory() {
    }
}

