/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.cryptographic.aes.props;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.algorithm.cryptographic.spi.CryptographicPropertiesProvider;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;

public final class DefaultAESPropertiesProvider
implements CryptographicPropertiesProvider {
    private static final String AES_KEY = "aes-key-value";
    private static final String DIGEST_ALGORITHM_NAME = "digest-algorithm-name";
    private byte[] secretKey;
    private String mode;
    private String padding;
    private byte[] ivParameter;
    private String encoder;

    public void init(Properties props) {
        this.secretKey = this.getSecretKey(props);
        this.mode = "";
        this.padding = "";
        this.ivParameter = new byte[0];
        this.encoder = "BASE64";
    }

    private byte[] getSecretKey(Properties props) {
        String aesKey = props.getProperty(AES_KEY);
        ShardingSpherePreconditions.checkNotEmpty((String)aesKey, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "%s can not be null or empty", new Object[]{AES_KEY}));
        String digestAlgorithm = props.getProperty(DIGEST_ALGORITHM_NAME);
        ShardingSpherePreconditions.checkNotEmpty((String)digestAlgorithm, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "%s can not be null or empty", new Object[]{DIGEST_ALGORITHM_NAME}));
        return Arrays.copyOf(DigestUtils.getDigest((String)digestAlgorithm.toUpperCase()).digest(aesKey.getBytes(StandardCharsets.UTF_8)), 16);
    }

    public String getType() {
        return "DEFAULT";
    }

    @Generated
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getPadding() {
        return this.padding;
    }

    @Generated
    public byte[] getIvParameter() {
        return this.ivParameter;
    }

    @Generated
    public String getEncoder() {
        return this.encoder;
    }
}

