/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.cryptographic.aes;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.shardingsphere.infra.algorithm.cryptographic.spi.CryptographicAlgorithm;
import org.apache.shardingsphere.infra.algorithm.cryptographic.spi.CryptographicPropertiesProvider;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class AESCryptographicAlgorithm
implements CryptographicAlgorithm {
    private CryptographicPropertiesProvider propsProvider;

    public void init(Properties props) {
        this.propsProvider = (CryptographicPropertiesProvider)TypedSPILoader.getService(CryptographicPropertiesProvider.class, (Object)"DEFAULT", (Properties)props);
    }

    public String encrypt(Object plainValue) {
        if (null == plainValue) {
            return null;
        }
        byte[] result = this.getCipher(1).doFinal(String.valueOf(plainValue).getBytes(StandardCharsets.UTF_8));
        return this.encode(result);
    }

    private String encode(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }

    public Object decrypt(Object cipherValue) {
        if (null == cipherValue) {
            return null;
        }
        byte[] result = this.getCipher(2).doFinal(this.decode(cipherValue.toString().trim()));
        return new String(result, StandardCharsets.UTF_8);
    }

    private byte[] decode(String value) {
        return Base64.getDecoder().decode(value);
    }

    private Cipher getCipher(int decryptMode) throws GeneralSecurityException {
        Cipher result = Cipher.getInstance(this.getType());
        result.init(decryptMode, new SecretKeySpec(this.propsProvider.getSecretKey(), this.getType()));
        return result;
    }

    public String getType() {
        return "AES";
    }
}

