/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.h2.jdbcurl;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.database.connector.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.props.PropertiesBuilder;

public final class H2ConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = -1;
    private static final String DEFAULT_HOST_NAME = "";
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:h2:((?<modelMem>mem|~)[:/](?<catalog>[\\w\\-]+)|(?<modelSslOrTcp>ssl:|tcp:)(//)?(?<hostname>[\\w\\-.]+)(:(?<port>\\d{1,4})/)?[/~\\w\\-.]+/(?<name>[\\-\\w]*)|(?<modelFile>file:)[/~\\w\\-]+/(?<fileName>[\\-\\w]*));?\\S*", 2);

    public ConnectionProperties parse(String url, String username, String catalog) {
        Matcher matcher = URL_PATTERN.matcher(url);
        ShardingSpherePreconditions.checkState((boolean)matcher.find(), () -> new UnrecognizedDatabaseURLException(url, URL_PATTERN.pattern()));
        return new ConnectionProperties(this.getHostname(matcher), this.getPort(matcher), H2ConnectionPropertiesParser.getCatalog(matcher), null, PropertiesBuilder.build((PropertiesBuilder.Property[])new PropertiesBuilder.Property[]{new PropertiesBuilder.Property("model", (Object)H2ConnectionPropertiesParser.getModel(matcher))}));
    }

    private String getHostname(Matcher matcher) {
        String hostname = matcher.group("hostname");
        return null == hostname ? DEFAULT_HOST_NAME : hostname;
    }

    private int getPort(Matcher matcher) {
        String port = matcher.group("port");
        return Strings.isNullOrEmpty((String)port) ? -1 : Integer.parseInt(port);
    }

    private static String getCatalog(Matcher matcher) {
        String name = matcher.group("name");
        if (null != name) {
            return name;
        }
        String fileName = matcher.group("fileName");
        if (null != fileName) {
            return fileName;
        }
        return matcher.group("catalog");
    }

    private static String getModel(Matcher matcher) {
        String modelMem = matcher.group("modelMem");
        if (null != modelMem) {
            return modelMem;
        }
        String modelSslOrTcp = matcher.group("modelSslOrTcp");
        if (null != modelSslOrTcp) {
            return modelSslOrTcp;
        }
        return matcher.group("modelFile");
    }

    public String getDatabaseType() {
        return "H2";
    }
}

