/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.spi;

import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPI;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DatabaseTypedSPILoader {
    public static <T extends DatabaseTypedSPI> Optional<T> findService(Class<T> spiClass, DatabaseType databaseType) {
        Optional result = TypedSPILoader.findService(spiClass, (Object)databaseType);
        if (result.isPresent()) {
            return result;
        }
        Optional<DatabaseType> trunkDatabaseType = databaseType.getTrunkDatabaseType();
        return trunkDatabaseType.isPresent() ? TypedSPILoader.findService(spiClass, (Object)trunkDatabaseType.get()) : result;
    }

    public static <T extends DatabaseTypedSPI> Optional<T> findService(Class<T> spiClass, DatabaseType databaseType, Properties props) {
        Optional result = TypedSPILoader.findService(spiClass, (Object)databaseType, (Properties)props);
        if (result.isPresent()) {
            return result;
        }
        Optional<DatabaseType> trunkDatabaseType = databaseType.getTrunkDatabaseType();
        return trunkDatabaseType.isPresent() ? TypedSPILoader.findService(spiClass, (Object)trunkDatabaseType.get(), (Properties)props) : result;
    }

    public static <T extends DatabaseTypedSPI> T getService(Class<T> spiClass, DatabaseType databaseType) {
        return (T)DatabaseTypedSPILoader.findService(spiClass, databaseType).orElseGet(() -> (DatabaseTypedSPI)TypedSPILoader.getService((Class)spiClass, null));
    }

    public static <T extends DatabaseTypedSPI> T getService(Class<T> spiClass, DatabaseType databaseType, Properties props) {
        return (T)((DatabaseTypedSPI)DatabaseTypedSPILoader.findService(spiClass, databaseType, props).orElseThrow(() -> new ServiceProviderNotFoundException(spiClass, (Object)databaseType.getType())));
    }

    @Generated
    private DatabaseTypedSPILoader() {
    }
}

