/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.database.system;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.DialectKernelSupportedSystemTable;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;

public final class SystemTable {
    private final DatabaseType databaseType;

    public boolean isSupportedSystemTable(String schemaName, String tableName) {
        if ("shardingsphere".equals(schemaName) && "cluster_information".equals(tableName)) {
            return true;
        }
        Optional<DialectKernelSupportedSystemTable> kernelSupportedSystemTable = DatabaseTypedSPILoader.findService(DialectKernelSupportedSystemTable.class, this.databaseType);
        return kernelSupportedSystemTable.map(optional -> ((Collection)optional.getSchemaAndTablesMap().getOrDefault(schemaName, Collections.emptySet())).contains(tableName)).orElse(false);
    }

    @Generated
    public SystemTable(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

