/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.data.loader.type;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderConnection;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.type.ColumnMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.type.IndexMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;

public final class TableMetaDataLoader {
    public static Optional<TableMetaData> load(DataSource dataSource, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        try (MetaDataLoaderConnection connection = new MetaDataLoaderConnection(databaseType, dataSource.getConnection());){
            String formattedTableNamePattern = new DatabaseTypeRegistry(databaseType).formatIdentifierPattern(tableNamePattern);
            Optional<TableMetaData> optional = TableMetaDataLoader.isTableExist(connection, formattedTableNamePattern) ? Optional.of(new TableMetaData(tableNamePattern, ColumnMetaDataLoader.load(connection, formattedTableNamePattern, databaseType), IndexMetaDataLoader.load(connection, formattedTableNamePattern), Collections.emptyList())) : Optional.empty();
            return optional;
        }
    }

    private static boolean isTableExist(Connection connection, String tableNamePattern) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), tableNamePattern, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Generated
    private TableMetaDataLoader() {
    }
}

