/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.data.loader.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderConnection;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.schema.DialectSchemaOption;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;

public final class SchemaMetaDataLoader {
    private static final String TABLE_TYPE = "TABLE";
    private static final String PARTITIONED_TABLE_TYPE = "PARTITIONED TABLE";
    private static final String VIEW_TYPE = "VIEW";
    private static final String SYSTEM_TABLE_TYPE = "SYSTEM TABLE";
    private static final String SYSTEM_VIEW_TYPE = "SYSTEM VIEW";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEME = "TABLE_SCHEM";
    private final DatabaseType databaseType;
    private final DialectSchemaOption schemaOption;

    public SchemaMetaDataLoader(DatabaseType databaseType) {
        this.databaseType = databaseType;
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        this.schemaOption = dialectDatabaseMetaData.getSchemaOption();
    }

    public Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DataSource dataSource, Collection<String> excludedTables) throws SQLException {
        try (MetaDataLoaderConnection connection = new MetaDataLoaderConnection(this.databaseType, dataSource.getConnection());){
            Collection<String> schemaNames = this.loadSchemaNames(connection);
            CaseInsensitiveMap result = new CaseInsensitiveMap(schemaNames.size(), 1.0f);
            for (String each : schemaNames) {
                String schemaName = this.schemaOption.getDefaultSchema().isPresent() ? each : databaseName;
                result.put(schemaName, this.loadTableNames(connection, each, excludedTables));
            }
            CaseInsensitiveMap caseInsensitiveMap = result;
            return caseInsensitiveMap;
        }
    }

    public Collection<String> loadSchemaNames(Connection connection) throws SQLException {
        if (!this.schemaOption.getDefaultSchema().isPresent()) {
            return Collections.singletonList(connection.getSchema());
        }
        LinkedList<String> result = new LinkedList<String>();
        SystemDatabase systemDatabase = new SystemDatabase(this.databaseType);
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            while (resultSet.next()) {
                String schema = resultSet.getString(TABLE_SCHEME);
                if (systemDatabase.getSystemSchemas().contains(schema)) continue;
                result.add(schema);
            }
        }
        return result.isEmpty() ? Collections.singletonList(connection.getSchema()) : result;
    }

    private Collection<String> loadTableNames(Connection connection, String schemaName, Collection<String> excludedTables) throws SQLException {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        String[] tableTypes = new String[]{TABLE_TYPE, PARTITIONED_TABLE_TYPE, VIEW_TYPE, SYSTEM_TABLE_TYPE, SYSTEM_VIEW_TYPE};
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), schemaName, null, tableTypes);){
            while (resultSet.next()) {
                String table = resultSet.getString(TABLE_NAME);
                if (this.isSystemTable(table) || excludedTables.contains(table)) continue;
                result.add(table);
            }
        }
        return result;
    }

    private boolean isSystemTable(String table) {
        return table.contains("$") || table.contains("/") || table.contains("##");
    }
}

