/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.data.loader.type;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.IndexMetaData;

public final class IndexMetaDataLoader {
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final int ORACLE_VIEW_NOT_APPROPRIATE_VENDOR_CODE = 1702;

    public static Collection<IndexMetaData> load(Connection connection, String table) throws SQLException {
        HashMap<String, IndexMetaData> result;
        block10: {
            result = new HashMap<String, IndexMetaData>();
            try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), connection.getSchema(), table, false, false);){
                while (resultSet.next()) {
                    String indexName = resultSet.getString(INDEX_NAME);
                    if (null == indexName) continue;
                    if (result.containsKey(indexName)) {
                        ((IndexMetaData)result.get(indexName)).getColumns().add(resultSet.getString("COLUMN_NAME"));
                        continue;
                    }
                    IndexMetaData indexMetaData = new IndexMetaData(indexName, new LinkedList<String>(Collections.singleton(resultSet.getString("COLUMN_NAME"))));
                    indexMetaData.setUnique(!resultSet.getBoolean("NON_UNIQUE"));
                    result.put(indexName, indexMetaData);
                }
            }
            catch (SQLException ex) {
                if (1702 == ex.getErrorCode()) break block10;
                throw ex;
            }
        }
        return result.values();
    }

    @Generated
    private IndexMetaDataLoader() {
    }
}

