/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.jdbcurl.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.database.connector.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;

public final class StandardJdbcUrlParser {
    private static final String SCHEMA_PATTERN = "(?<schema>[\\w-.+:%]+)\\s*";
    private static final String AUTHORITY_PATTERN = "(?://(?<authority>[^/?#]*))?\\s*";
    private static final String PATH_PATTERN = "(?:/(?!\\s*/)(?<path>[^?#]*))?";
    private static final String QUERY_PATTERN = "(?:\\?(?!\\s*\\?)(?<query>[^#]*))?";
    private static final Pattern CONNECTION_URL_PATTERN = Pattern.compile("(?<schema>[\\w-.+:%]+)\\s*(?://(?<authority>[^/?#]*))?\\s*(?:/(?!\\s*/)(?<path>[^?#]*))?(?:\\?(?!\\s*\\?)(?<query>[^#]*))?", 2);
    private static final String AUTHORITY_GROUP_KEY = "authority";
    private static final String PATH_GROUP_KEY = "path";
    private static final String QUERY_GROUP_KEY = "query";
    private static final String HOST_PORT_PATTERN = "((?<hostname>[\\w-.+%]+)|(\\[(?<ipv6hostname>[^]]+)]))\\s*(:\\s*(?<port>\\d+))?";
    private static final Pattern HOST_PORT_PATTERN_PATTERN = Pattern.compile("((?<hostname>[\\w-.+%]+)|(\\[(?<ipv6hostname>[^]]+)]))\\s*(:\\s*(?<port>\\d+))?");
    private static final String HOSTNAME_GROUP_KEY = "hostname";
    private static final String IPV6_HOSTNAME_GROUP_KEY = "ipv6hostname";
    private static final String PORT_GROUP_KEY = "port";
    private static final String SCHEMA_KEY = "schema";

    public ConnectionProperties parse(String jdbcUrl, int defaultPort) {
        Matcher matcher = CONNECTION_URL_PATTERN.matcher(jdbcUrl);
        ShardingSpherePreconditions.checkState((boolean)matcher.matches(), () -> new UnrecognizedDatabaseURLException(jdbcUrl, CONNECTION_URL_PATTERN.pattern().replaceAll("%", "%%")));
        String authority = matcher.group(AUTHORITY_GROUP_KEY);
        ShardingSpherePreconditions.checkNotNull((Object)authority, () -> new UnrecognizedDatabaseURLException(jdbcUrl, CONNECTION_URL_PATTERN.pattern().replaceAll("%", "%%")));
        Properties queryProperties = this.parseQueryProperties(matcher.group(QUERY_GROUP_KEY));
        String database = matcher.group(PATH_GROUP_KEY);
        String schema = queryProperties.getProperty(SCHEMA_KEY);
        if (authority.isEmpty()) {
            return new ConnectionProperties("", defaultPort, database, schema, queryProperties);
        }
        Matcher hostMatcher = HOST_PORT_PATTERN_PATTERN.matcher(authority);
        ShardingSpherePreconditions.checkState((boolean)hostMatcher.find(), () -> new UnrecognizedDatabaseURLException(jdbcUrl, CONNECTION_URL_PATTERN.pattern().replaceAll("%", "%%")));
        return new ConnectionProperties(this.parseHostname(hostMatcher), this.parsePort(hostMatcher, defaultPort), database, schema, queryProperties);
    }

    private String parseHostname(Matcher hostMatcher) {
        return Optional.ofNullable(hostMatcher.group(IPV6_HOSTNAME_GROUP_KEY)).orElse(hostMatcher.group(HOSTNAME_GROUP_KEY));
    }

    private int parsePort(Matcher hostMatcher, int defaultPort) {
        return Optional.ofNullable(hostMatcher.group(PORT_GROUP_KEY)).map(Integer::parseInt).orElse(defaultPort);
    }

    public Properties parseQueryProperties(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return new Properties();
        }
        Properties result = new Properties();
        for (String each : Splitter.on((String)"&").split((CharSequence)query)) {
            String[] property = each.split("=", 2);
            result.setProperty(property[0], property[1]);
        }
        return result;
    }
}

