/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.exception.external.sql;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.exception.external.ShardingSphereExternalException;
import org.apache.shardingsphere.infra.exception.external.sql.sqlstate.SQLState;

public abstract class ShardingSphereSQLException
extends ShardingSphereExternalException {
    private static final long serialVersionUID = -8238061892944243621L;
    private final String sqlState;
    private final int vendorCode;

    protected ShardingSphereSQLException(SQLState sqlState, int typeOffset, int errorCode, String reason, Object ... messageArgs) {
        this(sqlState.getValue(), typeOffset, errorCode, ShardingSphereSQLException.formatMessage(reason, messageArgs), null);
    }

    protected ShardingSphereSQLException(SQLState sqlState, int typeOffset, int errorCode, Exception cause, String reason, Object ... messageArgs) {
        this(sqlState.getValue(), typeOffset, errorCode, ShardingSphereSQLException.formatMessage(reason, messageArgs), cause);
    }

    protected ShardingSphereSQLException(String sqlState, int typeOffset, int errorCode, String reason, Exception cause) {
        super(ShardingSphereSQLException.getMessage(reason, cause), cause);
        this.sqlState = sqlState;
        Preconditions.checkArgument((typeOffset >= 0 && typeOffset < 4 ? 1 : 0) != 0, (Object)"The value range of type offset should be [0, 3].");
        Preconditions.checkArgument((errorCode >= 0 && errorCode < 10000 ? 1 : 0) != 0, (Object)"The value range of error code should be [0, 10000).");
        this.vendorCode = typeOffset * 10000 + errorCode;
    }

    private static String getMessage(String reason, Exception cause) {
        return null == cause ? reason : String.format("%s%sMore details: %s", reason, System.lineSeparator(), cause);
    }

    private static String formatMessage(String reason, Object[] messageArgs) {
        if (null == reason) {
            return null;
        }
        if (0 == messageArgs.length) {
            return reason;
        }
        return String.format(reason, ShardingSphereSQLException.formatMessageArguments(messageArgs));
    }

    private static Object[] formatMessageArguments(Object ... messageArgs) {
        return Arrays.stream(messageArgs).map(each -> each instanceof Collection ? ((Collection)each).stream().map(Object::toString).collect(Collectors.joining(", ")) : each).toArray(Object[]::new);
    }

    public final SQLException toSQLException() {
        return new SQLException(this.getMessage(), this.sqlState, this.vendorCode, this.getCause());
    }
}

